/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.cache;

import java.nio.ByteBuffer;
import java.util.Arrays;
import org.neo4j.unsafe.impl.batchimport.cache.ByteArray;
import org.neo4j.unsafe.impl.batchimport.cache.HeapNumberArray;

public class HeapByteArray
extends HeapNumberArray<ByteArray>
implements ByteArray {
    private final int length;
    private final byte[] array;
    private final ByteBuffer buffer;
    private final byte[] defaultValue;
    private final boolean defaultValueIsUniform;

    public HeapByteArray(int length, byte[] defaultValue, long base) {
        super(defaultValue.length, base);
        this.length = length;
        this.defaultValue = defaultValue;
        this.array = new byte[this.itemSize * length];
        this.buffer = ByteBuffer.wrap(this.array);
        this.defaultValueIsUniform = HeapByteArray.isUniform(defaultValue);
        this.clear();
    }

    @Override
    public long length() {
        return this.length;
    }

    @Override
    public void swap(long fromIndex, long toIndex) {
        byte[] a = (byte[])this.defaultValue.clone();
        byte[] b = (byte[])this.defaultValue.clone();
        this.get(fromIndex, a);
        this.get(toIndex, b);
        this.set(fromIndex, b);
        this.set(toIndex, a);
    }

    @Override
    public void clear() {
        if (this.defaultValueIsUniform) {
            Arrays.fill(this.array, this.defaultValue[0]);
        } else {
            for (int i = 0; i < this.length; ++i) {
                System.arraycopy(this.defaultValue, 0, this.array, i * this.itemSize, this.itemSize);
            }
        }
    }

    private static boolean isUniform(byte[] value) {
        byte reference = value[0];
        for (int i = 1; i < value.length; ++i) {
            if (reference == value[i]) continue;
            return false;
        }
        return true;
    }

    @Override
    public void get(long index, byte[] into) {
        System.arraycopy(this.array, this.index(index, 0), into, 0, this.itemSize);
    }

    @Override
    public byte getByte(long index, int offset) {
        return this.buffer.get(this.index(index, offset));
    }

    @Override
    public short getShort(long index, int offset) {
        return this.buffer.getShort(this.index(index, offset));
    }

    @Override
    public int getInt(long index, int offset) {
        return this.buffer.getInt(this.index(index, offset));
    }

    @Override
    public int get3ByteInt(long index, int offset) {
        int address = this.index(index, offset);
        return HeapByteArray.get3ByteIntFromByteBuffer(this.buffer, address);
    }

    @Override
    public long get6ByteLong(long index, int offset) {
        return HeapByteArray.get6BLongFromByteBuffer(this.buffer, this.index(index, offset));
    }

    protected static int get3ByteIntFromByteBuffer(ByteBuffer buffer, int address) {
        int lowWord = buffer.getShort(address) & 0xFFFF;
        byte highByte = buffer.get(address + 2);
        return lowWord | highByte << 16;
    }

    protected static long get6BLongFromByteBuffer(ByteBuffer buffer, int startOffset) {
        long low4b = (long)buffer.getInt(startOffset) & 0xFFFFFFFFL;
        long high2b = buffer.getShort(startOffset + 4);
        return low4b | high2b << 32;
    }

    @Override
    public long getLong(long index, int offset) {
        return this.buffer.getLong(this.index(index, offset));
    }

    @Override
    public void set(long index, byte[] value) {
        System.arraycopy(value, 0, this.array, this.index(index, 0), this.itemSize);
    }

    @Override
    public void setByte(long index, int offset, byte value) {
        this.buffer.put(this.index(index, offset), value);
    }

    @Override
    public void setShort(long index, int offset, short value) {
        this.buffer.putShort(this.index(index, offset), value);
    }

    @Override
    public void setInt(long index, int offset, int value) {
        this.buffer.putInt(this.index(index, offset), value);
    }

    @Override
    public void set6ByteLong(long index, int offset, long value) {
        int absIndex = this.index(index, offset);
        this.buffer.putInt(absIndex, (int)value);
        this.buffer.putShort(absIndex + 4, (short)(value >>> 32));
    }

    @Override
    public void setLong(long index, int offset, long value) {
        this.buffer.putLong(this.index(index, offset), value);
    }

    @Override
    public void set3ByteInt(long index, int offset, int value) {
        int address = this.index(index, offset);
        this.buffer.putShort(address, (short)value);
        this.buffer.put(address + 2, (byte)(value >>> 16));
    }

    private int index(long index, int offset) {
        return Math.toIntExact(this.rebase(index) * (long)this.itemSize + (long)offset);
    }
}

