/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.recovery;

import java.io.IOException;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.impl.api.TransactionQueue;
import org.neo4j.kernel.impl.api.TransactionToApply;
import org.neo4j.kernel.impl.transaction.CommittedTransactionRepresentation;
import org.neo4j.kernel.impl.transaction.TransactionRepresentation;
import org.neo4j.kernel.impl.transaction.log.Commitment;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.LogTailScanner;
import org.neo4j.kernel.impl.transaction.log.LogicalTransactionStore;
import org.neo4j.kernel.impl.transaction.log.PhysicalLogFiles;
import org.neo4j.kernel.impl.transaction.log.TransactionCursor;
import org.neo4j.kernel.impl.transaction.log.TransactionIdStore;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryStart;
import org.neo4j.kernel.recovery.PositionToRecoverFrom;
import org.neo4j.kernel.recovery.Recovery;
import org.neo4j.storageengine.api.StorageEngine;
import org.neo4j.storageengine.api.TransactionApplicationMode;

public class DefaultRecoverySPI
implements Recovery.SPI {
    private final PositionToRecoverFrom positionToRecoverFrom;
    private final PhysicalLogFiles logFiles;
    private final FileSystemAbstraction fs;
    private final StorageEngine storageEngine;
    private final TransactionIdStore transactionIdStore;
    private final LogicalTransactionStore logicalTransactionStore;

    public DefaultRecoverySPI(StorageEngine storageEngine, PhysicalLogFiles logFiles, FileSystemAbstraction fs, LogTailScanner logTailScanner, TransactionIdStore transactionIdStore, LogicalTransactionStore logicalTransactionStore, PositionToRecoverFrom.Monitor monitor) {
        this.storageEngine = storageEngine;
        this.logFiles = logFiles;
        this.fs = fs;
        this.transactionIdStore = transactionIdStore;
        this.logicalTransactionStore = logicalTransactionStore;
        this.positionToRecoverFrom = new PositionToRecoverFrom(logTailScanner, monitor);
    }

    @Override
    public LogPosition getPositionToRecoverFrom() throws IOException {
        return this.positionToRecoverFrom.get();
    }

    @Override
    public void startRecovery() {
        this.storageEngine.prepareForRecoveryRequired();
    }

    @Override
    public Recovery.RecoveryApplier getRecoveryApplier(TransactionApplicationMode mode) throws Exception {
        return new RecoveryVisitor(new TransactionQueue(100, (first, last) -> this.storageEngine.apply(first, mode)));
    }

    @Override
    public TransactionCursor getTransactions(LogPosition position) throws IOException {
        return this.logicalTransactionStore.getTransactions(position);
    }

    @Override
    public TransactionCursor getTransactionsInReverseOrder(LogPosition position) throws IOException {
        return this.logicalTransactionStore.getTransactionsInReverseOrder(position);
    }

    @Override
    public void allTransactionsRecovered(CommittedTransactionRepresentation lastRecoveredTransaction, LogPosition positionAfterLastRecoveredTransaction) throws Exception {
        if (lastRecoveredTransaction != null) {
            this.transactionIdStore.setLastCommittedAndClosedTransactionId(lastRecoveredTransaction.getCommitEntry().getTxId(), LogEntryStart.checksum(lastRecoveredTransaction.getStartEntry()), lastRecoveredTransaction.getCommitEntry().getTimeWritten(), positionAfterLastRecoveredTransaction.getByteOffset(), positionAfterLastRecoveredTransaction.getLogVersion());
        }
        this.fs.truncate(this.logFiles.getLogFileForVersion(positionAfterLastRecoveredTransaction.getLogVersion()), positionAfterLastRecoveredTransaction.getByteOffset());
    }

    static class RecoveryVisitor
    implements Recovery.RecoveryApplier {
        private final TransactionQueue transactionsToApply;

        RecoveryVisitor(TransactionQueue transactionsToApply) {
            this.transactionsToApply = transactionsToApply;
        }

        public boolean visit(CommittedTransactionRepresentation transaction) throws Exception {
            TransactionRepresentation txRepresentation = transaction.getTransactionRepresentation();
            long txId = transaction.getCommitEntry().getTxId();
            TransactionToApply tx = new TransactionToApply(txRepresentation, txId);
            tx.commitment(Commitment.NO_COMMITMENT, txId);
            tx.logPosition(transaction.getStartEntry().getStartPosition());
            this.transactionsToApply.queue(tx);
            return false;
        }

        @Override
        public void close() throws Exception {
            this.transactionsToApply.empty();
        }
    }
}

