/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.entry;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.StoreChannel;
import org.neo4j.kernel.impl.transaction.log.FlushableChannel;

public class LogHeaderWriter {
    private LogHeaderWriter() {
    }

    public static void writeLogHeader(FlushableChannel channel, long logVersion, long previousCommittedTxId) throws IOException {
        channel.putLong(LogHeaderWriter.encodeLogVersion(logVersion));
        channel.putLong(previousCommittedTxId);
    }

    public static ByteBuffer writeLogHeader(ByteBuffer buffer, long logVersion, long previousCommittedTxId) {
        buffer.clear();
        buffer.putLong(LogHeaderWriter.encodeLogVersion(logVersion));
        buffer.putLong(previousCommittedTxId);
        buffer.flip();
        return buffer;
    }

    public static void writeLogHeader(FileSystemAbstraction fileSystem, File file, long logVersion, long previousLastCommittedTxId) throws IOException {
        try (StoreChannel channel = fileSystem.open(file, "rw");){
            LogHeaderWriter.writeLogHeader(channel, logVersion, previousLastCommittedTxId);
        }
    }

    public static void writeLogHeader(StoreChannel channel, long logVersion, long previousLastCommittedTxId) throws IOException {
        ByteBuffer buffer = ByteBuffer.allocate(16);
        LogHeaderWriter.writeLogHeader(buffer, logVersion, previousLastCommittedTxId);
        channel.write(buffer);
    }

    public static long encodeLogVersion(long logVersion) {
        return logVersion | 0x600000000000000L;
    }
}

