/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log;

import java.io.Flushable;
import java.io.IOException;
import java.nio.channels.ClosedChannelException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.LockSupport;
import java.util.concurrent.locks.ReentrantLock;
import org.neo4j.kernel.impl.api.TransactionToApply;
import org.neo4j.kernel.impl.transaction.TransactionRepresentation;
import org.neo4j.kernel.impl.transaction.log.FlushablePositionAwareChannel;
import org.neo4j.kernel.impl.transaction.log.IndexCommandDetector;
import org.neo4j.kernel.impl.transaction.log.LogFile;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.LogPositionMarker;
import org.neo4j.kernel.impl.transaction.log.ThreadLink;
import org.neo4j.kernel.impl.transaction.log.TransactionAppender;
import org.neo4j.kernel.impl.transaction.log.TransactionCommitment;
import org.neo4j.kernel.impl.transaction.log.TransactionIdStore;
import org.neo4j.kernel.impl.transaction.log.TransactionLogWriter;
import org.neo4j.kernel.impl.transaction.log.TransactionMetadataCache;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryStart;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryWriter;
import org.neo4j.kernel.impl.transaction.log.rotation.LogRotation;
import org.neo4j.kernel.impl.transaction.tracing.LogAppendEvent;
import org.neo4j.kernel.impl.transaction.tracing.LogCheckPointEvent;
import org.neo4j.kernel.impl.transaction.tracing.LogForceEvent;
import org.neo4j.kernel.impl.transaction.tracing.LogForceEvents;
import org.neo4j.kernel.impl.transaction.tracing.LogForceWaitEvent;
import org.neo4j.kernel.impl.transaction.tracing.SerializeTransactionEvent;
import org.neo4j.kernel.impl.util.IdOrderingQueue;
import org.neo4j.kernel.internal.DatabaseHealth;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;

public class BatchingTransactionAppender
extends LifecycleAdapter
implements TransactionAppender {
    private final IdOrderingQueue explicitIndexTransactionOrdering;
    private final AtomicReference<ThreadLink> threadLinkHead = new AtomicReference<ThreadLink>(ThreadLink.END);
    private final TransactionMetadataCache transactionMetadataCache;
    private final LogFile logFile;
    private final LogRotation logRotation;
    private final TransactionIdStore transactionIdStore;
    private final LogPositionMarker positionMarker = new LogPositionMarker();
    private final DatabaseHealth databaseHealth;
    private final Lock forceLock = new ReentrantLock();
    private FlushablePositionAwareChannel writer;
    private TransactionLogWriter transactionLogWriter;
    private IndexCommandDetector indexCommandDetector;

    public BatchingTransactionAppender(LogFile logFile, LogRotation logRotation, TransactionMetadataCache transactionMetadataCache, TransactionIdStore transactionIdStore, IdOrderingQueue explicitIndexTransactionOrdering, DatabaseHealth databaseHealth) {
        this.logFile = logFile;
        this.logRotation = logRotation;
        this.transactionIdStore = transactionIdStore;
        this.explicitIndexTransactionOrdering = explicitIndexTransactionOrdering;
        this.databaseHealth = databaseHealth;
        this.transactionMetadataCache = transactionMetadataCache;
    }

    public void start() throws Throwable {
        this.writer = this.logFile.getWriter();
        this.indexCommandDetector = new IndexCommandDetector();
        this.transactionLogWriter = new TransactionLogWriter(new LogEntryWriter(this.writer));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long append(TransactionToApply batch, LogAppendEvent logAppendEvent) throws IOException {
        long lastTransactionId = 1L;
        LogFile logFile = this.logFile;
        synchronized (logFile) {
            this.databaseHealth.assertHealthy(IOException.class);
            try (SerializeTransactionEvent serialiseEvent = logAppendEvent.beginSerializeTransaction();){
                for (TransactionToApply tx = batch; tx != null; tx = tx.next()) {
                    long transactionId = this.transactionIdStore.nextCommittingTransactionId();
                    this.matchAgainstExpectedTransactionIdIfAny(transactionId, tx);
                    TransactionCommitment commitment = this.appendToLog(tx.transactionRepresentation(), transactionId);
                    tx.commitment(commitment, transactionId);
                    tx.logPosition(commitment.logPosition());
                    lastTransactionId = transactionId;
                }
            }
        }
        if (this.forceAfterAppend(logAppendEvent)) {
            boolean logRotated = this.logRotation.rotateLogIfNeeded(logAppendEvent);
            logAppendEvent.setLogRotated(logRotated);
        }
        this.publishAsCommitted(batch);
        return lastTransactionId;
    }

    private void matchAgainstExpectedTransactionIdIfAny(long transactionId, TransactionToApply tx) {
        long expectedTransactionId = tx.transactionId();
        if (expectedTransactionId != 0L && transactionId != expectedTransactionId) {
            IllegalStateException ex = new IllegalStateException("Received " + tx.transactionRepresentation() + " with txId:" + expectedTransactionId + " to be applied, but appending it ended up generating an unexpected txId:" + transactionId);
            this.databaseHealth.panic(ex);
            throw ex;
        }
    }

    private void publishAsCommitted(TransactionToApply batch) {
        while (batch != null) {
            batch.commitment().publishAsCommitted();
            batch = batch.next();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void checkPoint(LogPosition logPosition, LogCheckPointEvent logCheckPointEvent) throws IOException {
        try {
            LogFile logFile = this.logFile;
            synchronized (logFile) {
                this.transactionLogWriter.checkPoint(logPosition);
            }
        }
        catch (Throwable cause) {
            this.databaseHealth.panic(cause);
            throw cause;
        }
        this.forceAfterAppend(logCheckPointEvent);
    }

    private TransactionCommitment appendToLog(TransactionRepresentation transaction, long transactionId) throws IOException {
        this.indexCommandDetector.reset();
        try {
            LogPosition logPositionBeforeCommit = this.writer.getCurrentPosition(this.positionMarker).newPosition();
            this.transactionLogWriter.append(transaction, transactionId);
            LogPosition logPositionAfterCommit = this.writer.getCurrentPosition(this.positionMarker).newPosition();
            long transactionChecksum = LogEntryStart.checksum(transaction.additionalHeader(), transaction.getMasterId(), transaction.getAuthorId());
            this.transactionMetadataCache.cacheTransactionMetadata(transactionId, logPositionBeforeCommit, transaction.getMasterId(), transaction.getAuthorId(), transactionChecksum, transaction.getTimeCommitted());
            transaction.accept(this.indexCommandDetector);
            boolean hasExplicitIndexChanges = this.indexCommandDetector.hasWrittenAnyExplicitIndexCommand();
            if (hasExplicitIndexChanges) {
                this.explicitIndexTransactionOrdering.offer(transactionId);
            }
            return new TransactionCommitment(hasExplicitIndexChanges, transactionId, transactionChecksum, transaction.getTimeCommitted(), logPositionAfterCommit, this.transactionIdStore);
        }
        catch (Throwable panic) {
            this.databaseHealth.panic(panic);
            throw panic;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean forceAfterAppend(LogForceEvents logForceEvents) throws IOException {
        ThreadLink threadLink = new ThreadLink(Thread.currentThread());
        threadLink.next = this.threadLinkHead.getAndSet(threadLink);
        boolean attemptedForce = false;
        try (LogForceWaitEvent logForceWaitEvent = logForceEvents.beginLogForceWait();){
            do {
                if (this.forceLock.tryLock()) {
                    attemptedForce = true;
                    try {
                        this.forceLog(logForceEvents);
                    }
                    finally {
                        this.forceLock.unlock();
                        ThreadLink nextWaiter = this.threadLinkHead.get();
                        nextWaiter.unpark();
                    }
                } else {
                    this.waitForLogForce();
                }
            } while (!threadLink.done);
            if (!attemptedForce) {
                this.databaseHealth.assertHealthy(IOException.class);
            }
        }
        return attemptedForce;
    }

    private void forceLog(LogForceEvents logForceEvents) throws IOException {
        ThreadLink links = this.threadLinkHead.getAndSet(ThreadLink.END);
        try (LogForceEvent logForceEvent = logForceEvents.beginLogForce();){
            this.force();
        }
        catch (Throwable panic) {
            this.databaseHealth.panic(panic);
            throw panic;
        }
        finally {
            this.unparkAll(links);
        }
    }

    private void unparkAll(ThreadLink links) {
        ThreadLink tmp;
        do {
            links.done = true;
            links.unpark();
            while ((tmp = links.next) == null) {
            }
        } while ((links = tmp) != ThreadLink.END);
    }

    private void waitForLogForce() {
        long parkTime = TimeUnit.MILLISECONDS.toNanos(100L);
        LockSupport.parkNanos(this, parkTime);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void force() throws IOException {
        Flushable flushable;
        LogFile logFile = this.logFile;
        synchronized (logFile) {
            flushable = this.writer.prepareForFlush();
        }
        try {
            flushable.flush();
        }
        catch (ClosedChannelException closedChannelException) {
            // empty catch block
        }
    }
}

