/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.helpers;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Path;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.spatial.Coordinate;
import org.neo4j.graphdb.spatial.Geometry;
import org.neo4j.graphdb.spatial.Point;
import org.neo4j.helpers.NodeProxyWrappingNodeValue;
import org.neo4j.helpers.RelationshipProxyWrappingEdgeValue;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.values.AnyValue;
import org.neo4j.values.storable.NumberValue;
import org.neo4j.values.storable.TextValue;
import org.neo4j.values.storable.Values;
import org.neo4j.values.virtual.CoordinateReferenceSystem;
import org.neo4j.values.virtual.EdgeValue;
import org.neo4j.values.virtual.ListValue;
import org.neo4j.values.virtual.MapValue;
import org.neo4j.values.virtual.NodeValue;
import org.neo4j.values.virtual.PathValue;
import org.neo4j.values.virtual.PointValue;
import org.neo4j.values.virtual.VirtualValues;

public final class ValueUtils {
    private ValueUtils() {
        throw new UnsupportedOperationException("do not instantiate");
    }

    public static AnyValue of(Object object) {
        try {
            return Values.of((Object)object);
        }
        catch (IllegalArgumentException e) {
            if (object instanceof Node) {
                return ValueUtils.fromNodeProxy((Node)object);
            }
            if (object instanceof Relationship) {
                return ValueUtils.fromRelationshipProxy((Relationship)object);
            }
            if (object instanceof Path) {
                return ValueUtils.asPathValue((Path)object);
            }
            if (object instanceof Map) {
                return ValueUtils.asMapValue((Map)object);
            }
            if (object instanceof Iterable) {
                return ValueUtils.asListValue((Iterable)object);
            }
            if (object instanceof Iterator) {
                ArrayList objects = new ArrayList();
                Iterator iterator = (Iterator)object;
                while (iterator.hasNext()) {
                    objects.add(iterator.next());
                }
                return ValueUtils.asListValue(objects);
            }
            if (object instanceof Stream) {
                return ValueUtils.asListValue(((Stream)object).collect(Collectors.toList()));
            }
            if (object instanceof Point) {
                return ValueUtils.asPointValue((Point)object);
            }
            if (object instanceof Geometry) {
                return ValueUtils.asPointValue((Geometry)object);
            }
            if (object instanceof Object[]) {
                Object[] array = (Object[])object;
                AnyValue[] anyValues = new AnyValue[array.length];
                for (int i = 0; i < array.length; ++i) {
                    anyValues[i] = ValueUtils.of(array[i]);
                }
                return VirtualValues.list((AnyValue[])anyValues);
            }
            throw new IllegalArgumentException(String.format("Cannot convert %s to AnyValue", object.getClass().getName()));
        }
    }

    public static PointValue asPointValue(Point point) {
        return ValueUtils.toPoint((Geometry)point);
    }

    public static PointValue asPointValue(Geometry geometry) {
        if (!geometry.getGeometryType().equals("Point")) {
            throw new IllegalArgumentException("Cannot handle geometry type: " + geometry.getCRS().getType());
        }
        return ValueUtils.toPoint(geometry);
    }

    private static PointValue toPoint(Geometry geometry) {
        List coordinate = ((Coordinate)geometry.getCoordinates().get(0)).getCoordinate();
        if (geometry.getCRS().getCode() == CoordinateReferenceSystem.Cartesian.code) {
            return VirtualValues.pointCartesian((double)((Double)coordinate.get(0)), (double)((Double)coordinate.get(1)));
        }
        if (geometry.getCRS().getCode() == CoordinateReferenceSystem.WGS84.code) {
            return VirtualValues.pointGeographic((double)((Double)coordinate.get(0)), (double)((Double)coordinate.get(1)));
        }
        throw new IllegalArgumentException("Unknown coordinate reference system " + geometry.getCRS());
    }

    public static ListValue asListValue(Iterable<?> collection) {
        AnyValue[] anyValues = (AnyValue[])Iterables.stream(collection).map(ValueUtils::of).toArray(AnyValue[]::new);
        return VirtualValues.list((AnyValue[])anyValues);
    }

    public static AnyValue asNodeOrEdgeValue(PropertyContainer container) {
        if (container instanceof Node) {
            return ValueUtils.fromNodeProxy((Node)container);
        }
        if (container instanceof Relationship) {
            return ValueUtils.fromRelationshipProxy((Relationship)container);
        }
        throw new IllegalArgumentException("Cannot produce a node or edge from " + container.getClass().getName());
    }

    public static PathValue asPathValue(Path path) {
        NodeValue[] nodes = (NodeValue[])StreamSupport.stream(path.nodes().spliterator(), false).map(ValueUtils::fromNodeProxy).toArray(NodeValue[]::new);
        EdgeValue[] edges = (EdgeValue[])StreamSupport.stream(path.relationships().spliterator(), false).map(ValueUtils::fromRelationshipProxy).toArray(EdgeValue[]::new);
        return VirtualValues.path((NodeValue[])nodes, (EdgeValue[])edges);
    }

    public static ListValue asListOfEdges(Iterable<Relationship> rels) {
        return VirtualValues.list((AnyValue[])((AnyValue[])StreamSupport.stream(rels.spliterator(), false).map(ValueUtils::fromRelationshipProxy).toArray(EdgeValue[]::new)));
    }

    public static ListValue asListOfEdges(Relationship[] rels) {
        EdgeValue[] edgeValues = new EdgeValue[rels.length];
        for (int i = 0; i < edgeValues.length; ++i) {
            edgeValues[i] = ValueUtils.fromRelationshipProxy(rels[i]);
        }
        return VirtualValues.list((AnyValue[])edgeValues);
    }

    public static MapValue asMapValue(Map<String, Object> map) {
        return VirtualValues.map(ValueUtils.mapValues(map));
    }

    public static PointValue fromMap(MapValue map) {
        if (map.containsKey("x") && map.containsKey("y")) {
            double x = ((NumberValue)map.get("x")).doubleValue();
            double y = ((NumberValue)map.get("y")).doubleValue();
            if (!map.containsKey("crs")) {
                return VirtualValues.pointCartesian((double)x, (double)y);
            }
            TextValue crs = (TextValue)map.get("crs");
            if (crs.stringValue().equals(CoordinateReferenceSystem.Cartesian.type())) {
                return VirtualValues.pointCartesian((double)x, (double)y);
            }
            if (crs.stringValue().equals(CoordinateReferenceSystem.WGS84.type())) {
                return VirtualValues.pointGeographic((double)x, (double)y);
            }
            throw new IllegalArgumentException("Unknown coordinate reference system: " + crs.stringValue());
        }
        if (map.containsKey("latitude") && map.containsKey("longitude")) {
            double latitude = ((NumberValue)map.get("latitude")).doubleValue();
            double longitude = ((NumberValue)map.get("longitude")).doubleValue();
            if (!map.containsKey("crs")) {
                return VirtualValues.pointGeographic((double)longitude, (double)latitude);
            }
            TextValue crs = (TextValue)map.get("crs");
            if (crs.stringValue().equals(CoordinateReferenceSystem.WGS84.type())) {
                return VirtualValues.pointGeographic((double)longitude, (double)latitude);
            }
            throw new IllegalArgumentException("Geographic points does not support coordinate reference system: " + crs.stringValue());
        }
        throw new IllegalArgumentException("A point must contain either 'x' and 'y' or 'latitude' and 'longitude'");
    }

    private static Map<String, AnyValue> mapValues(Map<String, Object> map) {
        HashMap<String, AnyValue> newMap = new HashMap<String, AnyValue>(map.size());
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            newMap.put(entry.getKey(), ValueUtils.of(entry.getValue()));
        }
        return newMap;
    }

    public static NodeValue fromNodeProxy(Node node) {
        return new NodeProxyWrappingNodeValue(node);
    }

    public static EdgeValue fromRelationshipProxy(Relationship relationship) {
        return new RelationshipProxyWrappingEdgeValue(relationship);
    }
}

