/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.ExecutionException;
import java.util.function.Consumer;
import org.neo4j.concurrent.Work;
import org.neo4j.concurrent.WorkSync;
import org.neo4j.helpers.Exceptions;
import org.neo4j.index.internal.gbptree.GBPTree;
import org.neo4j.index.internal.gbptree.Layout;
import org.neo4j.index.internal.gbptree.RecoveryCleanupWorkCollector;
import org.neo4j.index.internal.gbptree.Writer;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.IOLimiter;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.api.exceptions.index.IndexEntryConflictException;
import org.neo4j.kernel.api.index.IndexEntryUpdate;
import org.neo4j.kernel.api.index.IndexPopulator;
import org.neo4j.kernel.api.index.IndexUpdater;
import org.neo4j.kernel.api.index.PropertyAccessor;
import org.neo4j.kernel.impl.index.schema.ConflictDetectingValueMerger;
import org.neo4j.kernel.impl.index.schema.FailureHeaderWriter;
import org.neo4j.kernel.impl.index.schema.NativeSchemaIndexHeaderWriter;
import org.neo4j.kernel.impl.index.schema.NativeSchemaNumberIndex;
import org.neo4j.kernel.impl.index.schema.NativeSchemaNumberIndexUpdater;
import org.neo4j.kernel.impl.index.schema.SchemaNumberKey;
import org.neo4j.kernel.impl.index.schema.SchemaNumberValue;

public abstract class NativeSchemaNumberIndexPopulator<KEY extends SchemaNumberKey, VALUE extends SchemaNumberValue>
extends NativeSchemaNumberIndex<KEY, VALUE>
implements IndexPopulator {
    static final byte BYTE_FAILED = 0;
    static final byte BYTE_ONLINE = 1;
    static final byte BYTE_POPULATING = 2;
    private final KEY treeKey;
    private final VALUE treeValue;
    private final ConflictDetectingValueMerger<KEY, VALUE> conflictDetectingValueMerger;
    private WorkSync<IndexUpdateApply<KEY, VALUE>, IndexUpdateWork<KEY, VALUE>> workSync;
    private Writer<KEY, VALUE> singleTreeWriter;
    private byte[] failureBytes;
    private boolean dropped;

    NativeSchemaNumberIndexPopulator(PageCache pageCache, FileSystemAbstraction fs, File storeFile, Layout<KEY, VALUE> layout) {
        super(pageCache, fs, storeFile, layout);
        this.treeKey = (SchemaNumberKey)((Object)layout.newKey());
        this.treeValue = (SchemaNumberValue)layout.newValue();
        this.conflictDetectingValueMerger = new ConflictDetectingValueMerger();
    }

    @Override
    public synchronized void create() throws IOException {
        this.gbpTreeFileUtil.deleteFileIfPresent(this.storeFile);
        this.instantiateTree(RecoveryCleanupWorkCollector.IMMEDIATE, new NativeSchemaIndexHeaderWriter(2));
        this.instantiateWriter();
        this.workSync = new WorkSync(new IndexUpdateApply<KEY, VALUE>(this.treeKey, this.treeValue, this.singleTreeWriter, this.conflictDetectingValueMerger));
    }

    void instantiateWriter() throws IOException {
        assert (this.singleTreeWriter == null);
        this.singleTreeWriter = this.tree.writer();
    }

    @Override
    public synchronized void drop() throws IOException {
        try {
            this.closeWriter();
            this.closeTree();
            this.gbpTreeFileUtil.deleteFileIfPresent(this.storeFile);
        }
        finally {
            this.dropped = true;
        }
    }

    @Override
    public void add(Collection<? extends IndexEntryUpdate<?>> updates) throws IndexEntryConflictException, IOException {
        this.applyWithWorkSync(updates);
    }

    @Override
    public void verifyDeferredConstraints(PropertyAccessor propertyAccessor) throws IndexEntryConflictException, IOException {
    }

    @Override
    public IndexUpdater newPopulatingUpdater(PropertyAccessor accessor) throws IOException {
        return new IndexUpdater(){
            private boolean closed;
            private final Collection<IndexEntryUpdate<?>> updates = new ArrayList();

            @Override
            public void process(IndexEntryUpdate<?> update) throws IOException, IndexEntryConflictException {
                this.assertOpen();
                this.updates.add(update);
            }

            @Override
            public void close() throws IOException, IndexEntryConflictException {
                NativeSchemaNumberIndexPopulator.this.applyWithWorkSync(this.updates);
                this.closed = true;
            }

            private void assertOpen() {
                if (this.closed) {
                    throw new IllegalStateException("Updater has been closed");
                }
            }
        };
    }

    @Override
    public synchronized void close(boolean populationCompletedSuccessfully) throws IOException {
        this.closeWriter();
        if (populationCompletedSuccessfully && this.failureBytes != null) {
            throw new IllegalStateException("Can't mark index as online after it has been marked as failure");
        }
        try {
            if (populationCompletedSuccessfully) {
                this.assertPopulatorOpen();
                this.markTreeAsOnline();
            } else {
                this.assertNotDropped();
                this.ensureTreeInstantiated();
                this.markTreeAsFailed();
            }
        }
        finally {
            this.closeTree();
        }
    }

    private void applyWithWorkSync(Collection<? extends IndexEntryUpdate<?>> updates) throws IOException {
        try {
            this.workSync.apply(new IndexUpdateWork(updates));
        }
        catch (ExecutionException e) {
            throw (IOException)Exceptions.launderedException(IOException.class, (Throwable)e);
        }
    }

    private void assertNotDropped() {
        if (this.dropped) {
            throw new IllegalStateException("Populator has already been dropped.");
        }
    }

    @Override
    public void markAsFailed(String failure) throws IOException {
        this.failureBytes = failure.getBytes(StandardCharsets.UTF_8);
    }

    private void ensureTreeInstantiated() throws IOException {
        if (this.tree == null) {
            this.instantiateTree(RecoveryCleanupWorkCollector.NULL, GBPTree.NO_HEADER_WRITER);
        }
    }

    private void assertPopulatorOpen() {
        if (this.tree == null) {
            throw new IllegalStateException("Populator has already been closed.");
        }
    }

    private void markTreeAsFailed() throws IOException {
        if (this.failureBytes == null) {
            this.failureBytes = new byte[0];
        }
        this.tree.checkpoint(IOLimiter.unlimited(), (Consumer)new FailureHeaderWriter(this.failureBytes));
    }

    private void markTreeAsOnline() throws IOException {
        this.tree.checkpoint(IOLimiter.unlimited(), pc -> pc.putByte((byte)1));
    }

    void closeWriter() throws IOException {
        this.singleTreeWriter = this.closeIfPresent(this.singleTreeWriter);
    }

    private static class IndexUpdateWork<KEY extends SchemaNumberKey, VALUE extends SchemaNumberValue>
    implements Work<IndexUpdateApply<KEY, VALUE>, IndexUpdateWork<KEY, VALUE>> {
        private final Collection<? extends IndexEntryUpdate<?>> updates;

        IndexUpdateWork(Collection<? extends IndexEntryUpdate<?>> updates) {
            this.updates = updates;
        }

        public IndexUpdateWork<KEY, VALUE> combine(IndexUpdateWork<KEY, VALUE> work) {
            ArrayList combined = new ArrayList(this.updates);
            combined.addAll(work.updates);
            return new IndexUpdateWork<KEY, VALUE>(combined);
        }

        public void apply(IndexUpdateApply<KEY, VALUE> indexUpdateApply) throws Exception {
            for (IndexEntryUpdate<?> indexEntryUpdate : this.updates) {
                indexUpdateApply.process(indexEntryUpdate);
            }
        }
    }

    private static class IndexUpdateApply<KEY extends SchemaNumberKey, VALUE extends SchemaNumberValue> {
        private final KEY treeKey;
        private final VALUE treeValue;
        private final Writer<KEY, VALUE> writer;
        private final ConflictDetectingValueMerger<KEY, VALUE> conflictDetectingValueMerger;

        IndexUpdateApply(KEY treeKey, VALUE treeValue, Writer<KEY, VALUE> writer, ConflictDetectingValueMerger<KEY, VALUE> conflictDetectingValueMerger) {
            this.treeKey = treeKey;
            this.treeValue = treeValue;
            this.writer = writer;
            this.conflictDetectingValueMerger = conflictDetectingValueMerger;
        }

        public void process(IndexEntryUpdate<?> indexEntryUpdate) throws Exception {
            NativeSchemaNumberIndexUpdater.processUpdate(this.treeKey, this.treeValue, indexEntryUpdate, this.writer, this.conflictDetectingValueMerger);
        }
    }
}

