/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.function.Consumer;
import org.neo4j.index.internal.gbptree.GBPTree;
import org.neo4j.index.internal.gbptree.Layout;
import org.neo4j.index.internal.gbptree.RecoveryCleanupWorkCollector;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.kernel.impl.index.GBPTreeFileUtil;
import org.neo4j.kernel.impl.index.schema.GBPTreeFileSystemFileUtil;
import org.neo4j.kernel.impl.index.schema.SchemaNumberKey;
import org.neo4j.kernel.impl.index.schema.SchemaNumberValue;

class NativeSchemaNumberIndex<KEY extends SchemaNumberKey, VALUE extends SchemaNumberValue> {
    final PageCache pageCache;
    final File storeFile;
    final Layout<KEY, VALUE> layout;
    final GBPTreeFileUtil gbpTreeFileUtil;
    GBPTree<KEY, VALUE> tree;

    NativeSchemaNumberIndex(PageCache pageCache, FileSystemAbstraction fs, File storeFile, Layout<KEY, VALUE> layout) {
        this.pageCache = pageCache;
        this.storeFile = storeFile;
        this.layout = layout;
        this.gbpTreeFileUtil = new GBPTreeFileSystemFileUtil(fs);
    }

    void instantiateTree(RecoveryCleanupWorkCollector recoveryCleanupWorkCollector, Consumer<PageCursor> headerWriter) throws IOException {
        this.ensureDirectoryExist();
        this.tree = new GBPTree(this.pageCache, this.storeFile, this.layout, 0, GBPTree.NO_MONITOR, GBPTree.NO_HEADER_READER, headerWriter, recoveryCleanupWorkCollector);
    }

    private void ensureDirectoryExist() throws IOException {
        this.gbpTreeFileUtil.mkdirs(this.storeFile.getParentFile());
    }

    void closeTree() throws IOException {
        this.tree = this.closeIfPresent((Closeable)this.tree);
    }

    <T extends Closeable> T closeIfPresent(T closeable) throws IOException {
        if (closeable != null) {
            closeable.close();
        }
        return null;
    }

    void assertOpen() {
        if (this.tree == null) {
            throw new IllegalStateException("Index has been closed");
        }
    }
}

