/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.configuration;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.neo4j.configuration.ConfigOptions;
import org.neo4j.configuration.ConfigValue;
import org.neo4j.configuration.LoadableConfig;
import org.neo4j.graphdb.config.Configuration;
import org.neo4j.graphdb.config.InvalidSettingException;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.graphdb.config.SettingValidator;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.configuration.AnnotationBasedConfigurationMigrator;
import org.neo4j.kernel.configuration.BoltConnector;
import org.neo4j.kernel.configuration.ConfigurationMigrator;
import org.neo4j.kernel.configuration.ConfigurationValidator;
import org.neo4j.kernel.configuration.Connector;
import org.neo4j.kernel.configuration.Group;
import org.neo4j.kernel.configuration.HttpConnector;
import org.neo4j.kernel.configuration.HttpConnectorValidator;
import org.neo4j.kernel.configuration.IndividualSettingsValidator;
import org.neo4j.kernel.configuration.ServerConfigurationValidator;
import org.neo4j.kernel.impl.util.CopyOnWriteHashMap;
import org.neo4j.kernel.info.DiagnosticsPhase;
import org.neo4j.kernel.info.DiagnosticsProvider;
import org.neo4j.logging.BufferingLog;
import org.neo4j.logging.Log;
import org.neo4j.logging.Logger;

public class Config
implements DiagnosticsProvider,
Configuration {
    public static final String DEFAULT_CONFIG_FILE_NAME = "neo4j.conf";
    private final List<ConfigOptions> configOptions;
    private final Map<String, String> params = new CopyOnWriteHashMap<String, String>();
    private final ConfigurationMigrator migrator;
    private final List<ConfigurationValidator> validators = new ArrayList<ConfigurationValidator>();
    private final Map<String, String> overriddenDefaults = new CopyOnWriteHashMap<String, String>();
    private Log log = new BufferingLog();

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    @Nonnull
    public static Builder fromFile(@Nullable File configFile) {
        return Config.builder().withFile(configFile);
    }

    @Nonnull
    public static Builder fromFile(@Nonnull Path configFile) {
        return Config.builder().withFile(configFile);
    }

    @Nonnull
    public static Builder fromSettings(Map<String, String> initialSettings) {
        return Config.builder().withSettings(initialSettings);
    }

    @Nonnull
    public static Config defaults() {
        return Config.builder().build();
    }

    @Nonnull
    public static Config defaults(@Nonnull Map<String, String> initialSettings) {
        return Config.builder().withSettings(initialSettings).build();
    }

    @Nonnull
    public static Config defaults(@Nonnull Setting<?> setting, @Nonnull String value) {
        return Config.builder().withSetting(setting, value).build();
    }

    private Config(File configFile, Map<String, String> initialSettings, Map<String, String> overriddenDefaults, Collection<ConfigurationValidator> additionalValidators, List<LoadableConfig> settingsClasses) {
        boolean fromFile;
        this.configOptions = settingsClasses.stream().map(LoadableConfig::getConfigOptions).flatMap(Collection::stream).collect(Collectors.toList());
        this.validators.addAll(additionalValidators);
        this.migrator = new AnnotationBasedConfigurationMigrator(settingsClasses);
        this.overriddenDefaults.putAll(overriddenDefaults);
        boolean bl = fromFile = configFile != null;
        if (fromFile) {
            Config.loadFromFile(configFile, this.log).forEach(initialSettings::putIfAbsent);
        }
        overriddenDefaults.forEach(initialSettings::putIfAbsent);
        this.migrateAndValidateAndUpdateSettings(initialSettings, fromFile);
        if (fromFile) {
            this.warnAboutDeprecations(this.params);
        }
    }

    public <T> T get(Setting<T> setting) {
        return (T)setting.apply(this.params::get);
    }

    public boolean isConfigured(Setting<?> setting) {
        return this.params.containsKey(setting.name());
    }

    public Set<String> identifiersFromGroup(Class<?> groupClass) {
        if (!groupClass.isAnnotationPresent(Group.class)) {
            throw new IllegalArgumentException("Class must be annotated with @Group");
        }
        String prefix = groupClass.getAnnotation(Group.class).value();
        Pattern pattern = Pattern.compile(Pattern.quote(prefix) + "\\.([^.]+)\\.(.+)");
        TreeSet<String> identifiers = new TreeSet<String>();
        for (String setting : this.params.keySet()) {
            Matcher matcher = pattern.matcher(setting);
            if (!matcher.matches()) continue;
            identifiers.add(matcher.group(1));
        }
        return identifiers;
    }

    public void augment(Map<String, String> settings) throws InvalidSettingException {
        this.migrateAndValidateAndUpdateSettings(settings, false);
    }

    public void augment(String setting, String value) throws InvalidSettingException {
        this.augment(Collections.singletonMap(setting, value));
    }

    public void augment(Setting<?> setting, String value) {
        this.augment(setting.name(), value);
    }

    public void augment(Config config) throws InvalidSettingException {
        this.augment(config.params);
    }

    public void augmentDefaults(Setting<?> setting, String value) throws InvalidSettingException {
        this.overriddenDefaults.put(setting.name(), value);
        this.params.putIfAbsent(setting.name(), value);
    }

    public void setLogger(Log log) {
        if (this.log instanceof BufferingLog) {
            ((BufferingLog)this.log).replayInto(log);
        }
        this.log = log;
    }

    public Optional<String> getRaw(@Nonnull String key) {
        return Optional.ofNullable(this.params.get(key));
    }

    public Map<String, String> getRaw() {
        return new HashMap<String, String>(this.params);
    }

    public Optional<?> getValue(@Nonnull String key) {
        return this.configOptions.stream().map(it -> it.asConfigValues(this.params)).flatMap(Collection::stream).filter(it -> it.name().equals(key)).map(ConfigValue::value).findFirst().orElse(Optional.empty());
    }

    public void updateDynamicSetting(String setting, String value) throws IllegalArgumentException, InvalidSettingException {
        Optional<ConfigValue> option = this.findConfigValue(setting);
        if (!option.isPresent()) {
            throw new IllegalArgumentException("Unknown setting: " + setting);
        }
        ConfigValue configValue = option.get();
        if (!configValue.dynamic()) {
            throw new IllegalArgumentException("Setting is not dynamic and can not be changed at runtime");
        }
        if (value == null || value.isEmpty()) {
            this.params.remove(setting);
            if (this.overriddenDefaults.containsKey(setting)) {
                this.params.put(setting, this.overriddenDefaults.get(setting));
            }
        } else {
            Map newEntry = MapUtil.stringMap((String[])new String[]{setting, value});
            List settingValidators = this.configOptions.stream().map(ConfigOptions::settingGroup).collect(Collectors.toList());
            for (SettingValidator validator : settingValidators) {
                validator.validate(newEntry, ignore -> {});
            }
            this.params.put(setting, value);
        }
    }

    private Optional<ConfigValue> findConfigValue(String setting) {
        return this.configOptions.stream().map(it -> it.asConfigValues(this.params)).flatMap(Collection::stream).filter(it -> it.name().equals(setting)).findFirst();
    }

    public Map<String, ConfigValue> getConfigValues() {
        return this.configOptions.stream().map(it -> it.asConfigValues(this.params)).flatMap(Collection::stream).collect(Collectors.toMap(ConfigValue::name, it -> it, (val1, val2) -> {
            throw new RuntimeException("Duplicate setting: " + val1.name() + ": " + val1 + " and " + val2);
        }));
    }

    @Override
    public String getDiagnosticsIdentifier() {
        return this.getClass().getName();
    }

    @Override
    public void acceptDiagnosticsVisitor(Object visitor) {
    }

    @Override
    public void dump(DiagnosticsPhase phase, Logger logger) {
        if (phase.isInitialization() || phase.isExplicitlyRequested()) {
            logger.log("Neo4j Kernel properties:");
            for (Map.Entry<String, String> param : this.params.entrySet()) {
                logger.log("%s=%s", new Object[]{param.getKey(), param.getValue()});
            }
        }
    }

    private void migrateAndValidateAndUpdateSettings(Map<String, String> settings, boolean warnOnUnknownSettings) throws InvalidSettingException {
        Map<String, String> migratedSettings = this.migrateSettings(settings);
        this.params.putAll(migratedSettings);
        List<SettingValidator> settingValidators = this.configOptions.stream().map(ConfigOptions::settingGroup).collect(Collectors.toList());
        Map<String, String> additionalSettings = new IndividualSettingsValidator(settingValidators, warnOnUnknownSettings).validate(this, this.log);
        this.params.putAll(additionalSettings);
        for (ConfigurationValidator validator : this.validators) {
            validator.validate(this, this.log);
        }
    }

    private Map<String, String> migrateSettings(Map<String, String> settings) {
        return this.migrator.apply(settings, this.log);
    }

    private void warnAboutDeprecations(Map<String, String> userSettings) {
        this.configOptions.stream().flatMap(it -> it.asConfigValues(userSettings).stream()).filter(config -> userSettings.containsKey(config.name()) && config.deprecated()).forEach(c -> {
            if (c.replacement().isPresent()) {
                this.log.warn("%s is deprecated. Replaced by %s", new Object[]{c.name(), c.replacement().get()});
            } else {
                this.log.warn("%s is deprecated.", new Object[]{c.name()});
            }
        });
    }

    @Nonnull
    private static Map<String, String> loadFromFile(@Nonnull File file, @Nonnull Log log) {
        if (!file.exists()) {
            log.warn("Config file [%s] does not exist.", new Object[]{file});
            return new HashMap<String, String>();
        }
        try {
            return MapUtil.load((File)file);
        }
        catch (IOException e) {
            log.error("Unable to load config file [%s]: %s", new Object[]{file, e.getMessage()});
            return new HashMap<String, String>();
        }
    }

    @Nonnull
    public Set<String> allConnectorIdentifiers() {
        return this.allConnectorIdentifiers(this.params);
    }

    @Nonnull
    public Set<String> allConnectorIdentifiers(@Nonnull Map<String, String> params) {
        return this.identifiersFromGroup(Connector.class);
    }

    @Nonnull
    public List<BoltConnector> boltConnectors() {
        return this.boltConnectors(this.params).collect(Collectors.toList());
    }

    @Nonnull
    private Stream<BoltConnector> boltConnectors(@Nonnull Map<String, String> params) {
        return this.allConnectorIdentifiers(params).stream().map(BoltConnector::new).filter(c -> {
            if (c.group.groupKey.equalsIgnoreCase("bolt")) return true;
            if (!Connector.ConnectorType.BOLT.equals(c.type.apply(params::get))) return false;
            return true;
        });
    }

    @Nonnull
    public List<BoltConnector> enabledBoltConnectors() {
        return this.enabledBoltConnectors(this.params);
    }

    @Nonnull
    public List<BoltConnector> enabledBoltConnectors(@Nonnull Map<String, String> params) {
        return this.boltConnectors(params).filter(c -> (Boolean)c.enabled.apply(params::get)).collect(Collectors.toList());
    }

    @Nonnull
    public List<HttpConnector> httpConnectors() {
        return this.httpConnectors(this.params).collect(Collectors.toList());
    }

    @Nonnull
    private Stream<HttpConnector> httpConnectors(@Nonnull Map<String, String> params) {
        return this.allConnectorIdentifiers(params).stream().map(Connector::new).filter(c -> {
            if (c.group.groupKey.equalsIgnoreCase("http")) return true;
            if (c.group.groupKey.equalsIgnoreCase("https")) return true;
            if (!Connector.ConnectorType.HTTP.equals(c.type.apply(params::get))) return false;
            return true;
        }).map(c -> {
            HttpConnector.Encryption defaultEncryption;
            String name;
            switch (name = c.group.groupKey) {
                case "https": {
                    defaultEncryption = HttpConnector.Encryption.TLS;
                    break;
                }
                default: {
                    defaultEncryption = HttpConnector.Encryption.NONE;
                }
            }
            return new HttpConnector(name, (HttpConnector.Encryption)((Object)((Object)HttpConnectorValidator.encryptionSetting(name, defaultEncryption).apply(params::get))));
        });
    }

    @Nonnull
    public List<HttpConnector> enabledHttpConnectors() {
        return this.enabledHttpConnectors(this.params);
    }

    @Nonnull
    private List<HttpConnector> enabledHttpConnectors(@Nonnull Map<String, String> params) {
        return this.httpConnectors(params).filter(c -> (Boolean)c.enabled.apply(params::get)).collect(Collectors.toList());
    }

    public String toString() {
        return this.params.entrySet().stream().sorted(Comparator.comparing(Map.Entry::getKey)).map(entry -> (String)entry.getKey() + "=" + (String)entry.getValue()).collect(Collectors.joining(", "));
    }

    public static class Builder {
        private Map<String, String> initialSettings = MapUtil.stringMap((String[])new String[0]);
        private Map<String, String> overriddenDefaults = MapUtil.stringMap((String[])new String[0]);
        private List<ConfigurationValidator> validators = new ArrayList<ConfigurationValidator>();
        private File configFile;
        private List<LoadableConfig> settingsClasses;
        private boolean connectorsDisabled;

        public Builder withSetting(Setting<?> setting, String value) {
            return this.withSetting(setting.name(), value);
        }

        public Builder withSetting(String setting, String value) {
            this.initialSettings.put(setting, value);
            return this;
        }

        public Builder withSettings(Map<String, String> initialSettings) {
            this.initialSettings.putAll(initialSettings);
            return this;
        }

        @Nonnull
        public Builder withConfigClasses(Collection<? extends LoadableConfig> loadableConfigs) {
            if (this.settingsClasses == null) {
                this.settingsClasses = new ArrayList<LoadableConfig>();
            }
            this.settingsClasses.addAll(loadableConfigs);
            return this;
        }

        @Nonnull
        public Builder withValidator(ConfigurationValidator validator) {
            this.validators.add(validator);
            return this;
        }

        @Nonnull
        public Builder withValidators(Collection<ConfigurationValidator> validators) {
            this.validators.addAll(validators);
            return this;
        }

        @Nonnull
        public Builder withServerDefaults() {
            HttpConnector http = new HttpConnector("http", HttpConnector.Encryption.NONE);
            HttpConnector https = new HttpConnector("https", HttpConnector.Encryption.TLS);
            BoltConnector bolt = new BoltConnector("bolt");
            this.overriddenDefaults.put(GraphDatabaseSettings.auth_enabled.name(), "true");
            this.overriddenDefaults.put(http.enabled.name(), "true");
            this.overriddenDefaults.put(https.enabled.name(), "true");
            this.overriddenDefaults.put(bolt.enabled.name(), "true");
            this.validators.add(new ServerConfigurationValidator());
            return this;
        }

        @Nonnull
        public Builder withFile(@Nullable File configFile) {
            this.configFile = configFile;
            return this;
        }

        @Nonnull
        public Builder withFile(Path configFile) {
            return this.withFile(configFile.toFile());
        }

        @Nonnull
        public Builder withFile(Optional<File> configFile) {
            configFile.ifPresent(file -> {
                this.configFile = file;
            });
            return this;
        }

        @Nonnull
        public Builder withHome(File homeDir) {
            this.initialSettings.put(GraphDatabaseSettings.neo4j_home.name(), homeDir.getAbsolutePath());
            return this;
        }

        @Nonnull
        public Builder withHome(Path homeDir) {
            return this.withHome(homeDir.toFile());
        }

        @Nonnull
        public Builder withConnectorsDisabled() {
            this.connectorsDisabled = true;
            return this;
        }

        @Nonnull
        public Config build() throws InvalidSettingException {
            List<LoadableConfig> loadableConfigs = Optional.ofNullable(this.settingsClasses).orElse(LoadableConfig.allConfigClasses());
            if (this.configFile != null && !this.initialSettings.containsKey(GraphDatabaseSettings.neo4j_home.name())) {
                this.initialSettings.put(GraphDatabaseSettings.neo4j_home.name(), System.getProperty("user.dir"));
            }
            Config config = new Config(this.configFile, this.initialSettings, this.overriddenDefaults, this.validators, loadableConfigs);
            if (this.connectorsDisabled) {
                config.augment(config.allConnectorIdentifiers().stream().collect(Collectors.toMap(id -> new Connector((String)id).enabled.name(), id -> "false")));
            }
            return config;
        }
    }
}

