/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Iterator;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.helpers.collection.BoundedIterable;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.index.internal.gbptree.GBPTree;
import org.neo4j.index.internal.gbptree.Layout;
import org.neo4j.index.internal.gbptree.RecoveryCleanupWorkCollector;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.IOLimiter;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.api.exceptions.index.IndexEntryConflictException;
import org.neo4j.kernel.api.index.IndexAccessor;
import org.neo4j.kernel.api.index.IndexUpdater;
import org.neo4j.kernel.api.index.PropertyAccessor;
import org.neo4j.kernel.impl.api.index.IndexUpdateMode;
import org.neo4j.kernel.impl.index.schema.NativeSchemaNumberIndex;
import org.neo4j.kernel.impl.index.schema.NativeSchemaNumberIndexReader;
import org.neo4j.kernel.impl.index.schema.NativeSchemaNumberIndexUpdater;
import org.neo4j.kernel.impl.index.schema.NumberAllEntriesReader;
import org.neo4j.kernel.impl.index.schema.SchemaNumberKey;
import org.neo4j.kernel.impl.index.schema.SchemaNumberValue;
import org.neo4j.storageengine.api.schema.IndexReader;

public class NativeSchemaNumberIndexAccessor<KEY extends SchemaNumberKey, VALUE extends SchemaNumberValue>
extends NativeSchemaNumberIndex<KEY, VALUE>
implements IndexAccessor {
    private final NativeSchemaNumberIndexUpdater<KEY, VALUE> singleUpdater;

    NativeSchemaNumberIndexAccessor(PageCache pageCache, FileSystemAbstraction fs, File storeFile, Layout<KEY, VALUE> layout, RecoveryCleanupWorkCollector recoveryCleanupWorkCollector) throws IOException {
        super(pageCache, fs, storeFile, layout);
        this.singleUpdater = new NativeSchemaNumberIndexUpdater<SchemaNumberKey, SchemaNumberValue>((SchemaNumberKey)((Object)layout.newKey()), (SchemaNumberValue)layout.newValue());
        this.instantiateTree(recoveryCleanupWorkCollector, GBPTree.NO_HEADER_WRITER);
    }

    @Override
    public void drop() throws IOException {
        this.closeTree();
        this.gbpTreeFileUtil.deleteFile(this.storeFile);
    }

    @Override
    public IndexUpdater newUpdater(IndexUpdateMode mode) {
        this.assertOpen();
        try {
            return this.singleUpdater.initialize(this.tree.writer(), true);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public void force() throws IOException {
        this.tree.checkpoint(IOLimiter.unlimited());
    }

    @Override
    public void close() throws IOException {
        this.closeTree();
    }

    @Override
    public IndexReader newReader() {
        this.assertOpen();
        return new NativeSchemaNumberIndexReader(this.tree, this.layout);
    }

    @Override
    public BoundedIterable<Long> newAllEntriesReader() {
        return new NumberAllEntriesReader(this.tree, this.layout);
    }

    @Override
    public ResourceIterator<File> snapshotFiles() throws IOException {
        return Iterators.asResourceIterator((Iterator)Iterators.iterator((Object)this.storeFile));
    }

    @Override
    public void verifyDeferredConstraints(PropertyAccessor propertyAccessor) throws IndexEntryConflictException, IOException {
    }
}

