/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.helpers;

import java.util.concurrent.TimeUnit;
import java.util.function.Function;

public final class TimeUtil {
    public static final TimeUnit DEFAULT_TIME_UNIT = TimeUnit.SECONDS;
    public static final String VALID_TIME_DESCRIPTION = "Valid units are: 'ms', 's', 'm' and 'h'; default unit is 's'";
    public static final Function<String, Long> parseTimeMillis = timeWithOrWithoutUnit -> {
        int unitIndex = -1;
        for (int i = 0; i < timeWithOrWithoutUnit.length(); ++i) {
            char ch = timeWithOrWithoutUnit.charAt(i);
            if (Character.isDigit(ch)) continue;
            unitIndex = i;
            break;
        }
        if (unitIndex == -1) {
            return DEFAULT_TIME_UNIT.toMillis(Integer.parseInt(timeWithOrWithoutUnit));
        }
        String unit = timeWithOrWithoutUnit.substring(unitIndex).toLowerCase();
        if (unitIndex == 0) {
            throw new IllegalArgumentException("Missing numeric value");
        }
        int amount = Integer.parseInt(timeWithOrWithoutUnit.substring(0, unitIndex));
        switch (unit) {
            case "ms": {
                return TimeUnit.MILLISECONDS.toMillis(amount);
            }
            case "s": {
                return TimeUnit.SECONDS.toMillis(amount);
            }
            case "m": {
                return TimeUnit.MINUTES.toMillis(amount);
            }
            case "h": {
                return TimeUnit.HOURS.toMillis(amount);
            }
        }
        throw new IllegalArgumentException("Unrecognized unit '" + unit + "'. " + VALID_TIME_DESCRIPTION);
    };

    private TimeUtil() {
        throw new AssertionError();
    }
}

