/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.state;

import org.neo4j.kernel.impl.store.RecordStore;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.store.record.Record;
import org.neo4j.kernel.impl.store.record.RelationshipGroupRecord;
import org.neo4j.kernel.impl.transaction.state.RecordAccess;

public class RelationshipGroupGetter {
    private final RecordStore<RelationshipGroupRecord> store;

    public RelationshipGroupGetter(RecordStore<RelationshipGroupRecord> store) {
        this.store = store;
    }

    public RelationshipGroupPosition getRelationshipGroup(NodeRecord node, int type, RecordAccess<RelationshipGroupRecord, Integer> relGroupRecords) {
        long groupId = node.getNextRel();
        long previousGroupId = Record.NO_NEXT_RELATIONSHIP.intValue();
        RecordAccess.RecordProxy<RelationshipGroupRecord, Object> previous = null;
        while (groupId != (long)Record.NO_NEXT_RELATIONSHIP.intValue()) {
            RecordAccess.RecordProxy<RelationshipGroupRecord, Object> current = relGroupRecords.getOrLoad(groupId, null);
            RelationshipGroupRecord record = current.forReadingData();
            record.setPrev(previousGroupId);
            if (record.getType() == type) {
                return new RelationshipGroupPosition(previous, current);
            }
            if (record.getType() > type) {
                return new RelationshipGroupPosition(previous, null);
            }
            previousGroupId = groupId;
            groupId = record.getNext();
            previous = current;
        }
        return new RelationshipGroupPosition(previous, null);
    }

    public RecordAccess.RecordProxy<RelationshipGroupRecord, Integer> getOrCreateRelationshipGroup(NodeRecord node, int type, RecordAccess<RelationshipGroupRecord, Integer> relGroupRecords) {
        RelationshipGroupPosition existingGroup = this.getRelationshipGroup(node, type, relGroupRecords);
        RecordAccess.RecordProxy<RelationshipGroupRecord, Integer> change = existingGroup.group();
        if (change == null) {
            assert (node.isDense()) : "Node " + node + " should have been dense at this point";
            long id = this.store.nextId();
            change = relGroupRecords.create(id, type);
            RelationshipGroupRecord record = change.forChangingData();
            record.setInUse(true);
            record.setCreated();
            record.setOwningNode(node.getId());
            RecordAccess.RecordProxy<RelationshipGroupRecord, Integer> closestPreviousChange = existingGroup.closestPrevious();
            if (closestPreviousChange != null) {
                RelationshipGroupRecord closestPrevious = closestPreviousChange.forChangingLinkage();
                record.setNext(closestPrevious.getNext());
                record.setPrev(closestPrevious.getId());
                closestPrevious.setNext(id);
            } else {
                long firstGroupId = node.getNextRel();
                if (firstGroupId != (long)Record.NO_NEXT_RELATIONSHIP.intValue()) {
                    RelationshipGroupRecord previousFirstRecord = relGroupRecords.getOrLoad(firstGroupId, type).forReadingData();
                    record.setNext(previousFirstRecord.getId());
                    previousFirstRecord.setPrev(id);
                }
                node.setNextRel(id);
            }
        }
        return change;
    }

    public static class RelationshipGroupPosition {
        private final RecordAccess.RecordProxy<RelationshipGroupRecord, Integer> closestPrevious;
        private final RecordAccess.RecordProxy<RelationshipGroupRecord, Integer> group;

        public RelationshipGroupPosition(RecordAccess.RecordProxy<RelationshipGroupRecord, Integer> closestPrevious, RecordAccess.RecordProxy<RelationshipGroupRecord, Integer> group) {
            this.closestPrevious = closestPrevious;
            this.group = group;
        }

        public RecordAccess.RecordProxy<RelationshipGroupRecord, Integer> group() {
            return this.group;
        }

        public RecordAccess.RecordProxy<RelationshipGroupRecord, Integer> closestPrevious() {
            return this.closestPrevious;
        }
    }
}

