/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.entry;

import java.io.IOException;
import org.neo4j.helpers.Exceptions;
import org.neo4j.kernel.impl.storageengine.impl.recordstorage.RecordStorageCommandReaderFactory;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.LogPositionMarker;
import org.neo4j.kernel.impl.transaction.log.PositionableChannel;
import org.neo4j.kernel.impl.transaction.log.ReadableClosableChannel;
import org.neo4j.kernel.impl.transaction.log.ReadableClosablePositionAwareChannel;
import org.neo4j.kernel.impl.transaction.log.entry.InvalidLogEntryHandler;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntry;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryParser;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryReader;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntrySanity;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryVersion;
import org.neo4j.storageengine.api.CommandReaderFactory;
import org.neo4j.storageengine.api.ReadPastEndException;

public class VersionAwareLogEntryReader<SOURCE extends ReadableClosablePositionAwareChannel>
implements LogEntryReader<SOURCE> {
    private final CommandReaderFactory commandReaderFactory;
    private final InvalidLogEntryHandler invalidLogEntryHandler;

    public VersionAwareLogEntryReader() {
        this(new RecordStorageCommandReaderFactory(), InvalidLogEntryHandler.STRICT);
    }

    public VersionAwareLogEntryReader(CommandReaderFactory commandReaderFactory, InvalidLogEntryHandler invalidLogEntryHandler) {
        this.commandReaderFactory = commandReaderFactory;
        this.invalidLogEntryHandler = invalidLogEntryHandler;
    }

    @Override
    public LogEntry readLogEntry(SOURCE channel) throws IOException {
        try {
            LogEntry entry;
            LogPositionMarker positionMarker = new LogPositionMarker();
            long skipped = 0L;
            while (true) {
                LogEntryParser<LogEntry> entryReader;
                channel.getCurrentPosition(positionMarker);
                byte versionCode = channel.get();
                if (versionCode == 0) {
                    return null;
                }
                byte typeCode = channel.get();
                LogEntryVersion version = null;
                try {
                    version = LogEntryVersion.byVersion(versionCode);
                    entryReader = version.entryParser(typeCode);
                    entry = entryReader.parse(version, (ReadableClosableChannel)channel, positionMarker, this.commandReaderFactory);
                    if (entry != null && skipped > 0L) {
                        if (!LogEntrySanity.logEntryMakesSense(entry)) {
                            throw new IllegalArgumentException("Log entry " + entry + " which was read after a bad section of " + skipped + " bytes was read successfully, but its contents is unrealistic, so treating as part of bad section");
                        }
                        this.invalidLogEntryHandler.bytesSkipped(skipped);
                        skipped = 0L;
                    }
                }
                catch (Exception e) {
                    LogPosition position = positionMarker.newPosition();
                    e = (Exception)Exceptions.withMessage((Throwable)e, (String)(e.getMessage() + ". At position " + position + " and entry version " + (Object)((Object)version)));
                    if (this.channelSupportsPositioning(channel) && this.invalidLogEntryHandler.handleInvalidEntry(e, position)) {
                        ((PositionableChannel)channel).setCurrentPosition(positionMarker.getByteOffset() + 1L);
                        ++skipped;
                        continue;
                    }
                    throw (IOException)Exceptions.launderedException(IOException.class, (Throwable)e);
                }
                if (!entryReader.skip()) break;
            }
            return entry;
        }
        catch (ReadPastEndException e) {
            return null;
        }
    }

    private boolean channelSupportsPositioning(SOURCE channel) {
        return channel instanceof PositionableChannel;
    }
}

