/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.locking;

import java.lang.reflect.Array;
import java.util.HashMap;
import java.util.Map;
import org.neo4j.hashing.HashFunction;
import org.neo4j.helpers.Strings;
import org.neo4j.kernel.api.schema.IndexQuery;
import org.neo4j.kernel.impl.util.concurrent.LockWaitStrategies;
import org.neo4j.storageengine.api.lock.ResourceType;
import org.neo4j.storageengine.api.lock.WaitStrategy;
import org.neo4j.unsafe.impl.internal.dragons.FeatureToggles;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

public enum ResourceTypes implements ResourceType
{
    NODE(0, LockWaitStrategies.INCREMENTAL_BACKOFF),
    RELATIONSHIP(1, LockWaitStrategies.INCREMENTAL_BACKOFF),
    GRAPH_PROPS(2, LockWaitStrategies.INCREMENTAL_BACKOFF),
    INDEX_ENTRY(4, LockWaitStrategies.INCREMENTAL_BACKOFF),
    LEGACY_INDEX(5, LockWaitStrategies.INCREMENTAL_BACKOFF),
    LABEL(6, LockWaitStrategies.INCREMENTAL_BACKOFF),
    RELATIONSHIP_TYPE(7, LockWaitStrategies.INCREMENTAL_BACKOFF);

    private static final boolean useStrongHashing;
    private static final Map<Integer, ResourceType> idToType;
    private static final HashFunction indexEntryHash_2_2_0;
    private static final HashFunction indexEntryHash_4_x;
    private final int typeId;
    private final WaitStrategy waitStrategy;

    private ResourceTypes(int typeId, WaitStrategy waitStrategy) {
        this.typeId = typeId;
        this.waitStrategy = waitStrategy;
    }

    @Override
    public int typeId() {
        return this.typeId;
    }

    @Override
    public WaitStrategy waitStrategy() {
        return this.waitStrategy;
    }

    public static long legacyIndexResourceId(String name, String key) {
        return (long)name.hashCode() << 32 | (long)key.hashCode();
    }

    public static long indexEntryResourceId(long labelId, IndexQuery.ExactPredicate ... predicates) {
        if (!useStrongHashing) {
            return ResourceTypes.indexEntryResourceId_2_2_0(labelId, predicates);
        }
        return ResourceTypes.indexEntryResourceId_4_x(labelId, predicates);
    }

    static long indexEntryResourceId_2_2_0(long labelId, IndexQuery.ExactPredicate[] predicates) {
        return ResourceTypes.indexEntryResourceId_2_2_0(labelId, predicates, 0);
    }

    private static long indexEntryResourceId_2_2_0(long labelId, IndexQuery.ExactPredicate[] predicates, int i) {
        int propertyKeyId = predicates[i].propertyKeyId();
        Value value = predicates[i].value();
        long hash = ResourceTypes.indexEntryResourceId_2_2_0(labelId, propertyKeyId, ResourceTypes.stringOf(value));
        if (++i < predicates.length) {
            hash = ResourceTypes.hash(hash + ResourceTypes.indexEntryResourceId_2_2_0(labelId, predicates, i));
        }
        return hash;
    }

    private static long indexEntryResourceId_2_2_0(long labelId, long propertyKeyId, String propertyValue) {
        long hob = ResourceTypes.hash(labelId + (long)ResourceTypes.hash(propertyKeyId));
        return (hob <<= 32) + (long)propertyValue.hashCode();
    }

    private static String stringOf(Value value) {
        if (value != null && value != Values.NO_VALUE) {
            return Strings.prettyPrint(value.asObject());
        }
        return "";
    }

    private static int hash(long value) {
        return indexEntryHash_2_2_0.hashSingleValueToInt(value);
    }

    public static long graphPropertyResource() {
        return 0L;
    }

    public static ResourceType fromId(int typeId) {
        return idToType.get(typeId);
    }

    static long indexEntryResourceId_4_x(long labelId, IndexQuery.ExactPredicate[] predicates) {
        long hash = indexEntryHash_4_x.initialise(81985529216486895L);
        hash = indexEntryHash_4_x.update(hash, labelId);
        for (IndexQuery.ExactPredicate predicate : predicates) {
            int i;
            int propertyKeyId = predicate.propertyKeyId();
            Value v = predicate.value();
            Object value = v.asObject();
            Class<?> type = value.getClass();
            hash = indexEntryHash_4_x.update(hash, (long)propertyKeyId);
            if (type == String.class) {
                String str = (String)value;
                int length = str.length();
                hash = indexEntryHash_4_x.update(hash, (long)length);
                for (i = 0; i < length; ++i) {
                    hash = indexEntryHash_4_x.update(hash, (long)str.charAt(i));
                }
                continue;
            }
            if (type.isArray()) {
                int length = Array.getLength(value);
                Class<?> componentType = type.getComponentType();
                hash = indexEntryHash_4_x.update(hash, (long)length);
                if (componentType == String.class) {
                    for (i = 0; i < length; ++i) {
                        String str = (String)Array.get(value, i);
                        int len = str.length();
                        hash = indexEntryHash_4_x.update(hash, (long)len);
                        for (int j = 0; j < len; ++j) {
                            hash = indexEntryHash_4_x.update(hash, (long)str.charAt(j));
                        }
                    }
                    continue;
                }
                if (componentType == Double.TYPE) {
                    for (i = 0; i < length; ++i) {
                        hash = indexEntryHash_4_x.update(hash, Double.doubleToLongBits(Array.getDouble(value, i)));
                    }
                    continue;
                }
                if (componentType == Boolean.TYPE) {
                    for (i = 0; i < length; ++i) {
                        hash = indexEntryHash_4_x.update(hash, (long)Boolean.hashCode(Array.getBoolean(value, i)));
                    }
                    continue;
                }
                if (componentType == Character.TYPE) {
                    for (i = 0; i < length; ++i) {
                        hash = indexEntryHash_4_x.update(hash, (long)Array.getChar(value, i));
                    }
                    continue;
                }
                for (i = 0; i < length; ++i) {
                    hash = indexEntryHash_4_x.update(hash, ((Number)Array.get(value, i)).longValue());
                }
                continue;
            }
            hash = type == Double.class ? indexEntryHash_4_x.update(hash, Double.doubleToLongBits((Double)value)) : (type == Boolean.class ? indexEntryHash_4_x.update(hash, (long)value.hashCode()) : (type == Character.class ? indexEntryHash_4_x.update(hash, (long)((Character)value).charValue()) : indexEntryHash_4_x.update(hash, ((Number)value).longValue())));
        }
        return indexEntryHash_4_x.finalise(hash);
    }

    static {
        useStrongHashing = FeatureToggles.flag(ResourceTypes.class, (String)"useStrongHashing", (boolean)false);
        idToType = new HashMap<Integer, ResourceType>();
        indexEntryHash_2_2_0 = HashFunction.xorShift32();
        indexEntryHash_4_x = HashFunction.incrementalXXH64();
        for (ResourceTypes resourceTypes : ResourceTypes.values()) {
            idToType.put(resourceTypes.typeId, resourceTypes);
        }
    }
}

