/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.HashSet;
import java.util.Set;
import org.neo4j.collection.primitive.PrimitiveLongIterator;
import org.neo4j.cursor.RawCursor;
import org.neo4j.index.internal.gbptree.GBPTree;
import org.neo4j.index.internal.gbptree.Hit;
import org.neo4j.index.internal.gbptree.Layout;
import org.neo4j.io.IOUtils;
import org.neo4j.kernel.api.exceptions.index.IndexNotApplicableKernelException;
import org.neo4j.kernel.api.schema.IndexQuery;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.api.index.sampling.IndexSamplingConfig;
import org.neo4j.kernel.impl.index.schema.FullScanNonUniqueIndexSampler;
import org.neo4j.kernel.impl.index.schema.NumberHitIterator;
import org.neo4j.kernel.impl.index.schema.SchemaNumberKey;
import org.neo4j.kernel.impl.index.schema.SchemaNumberValue;
import org.neo4j.storageengine.api.schema.IndexReader;
import org.neo4j.storageengine.api.schema.IndexSampler;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

class NativeSchemaNumberIndexReader<KEY extends SchemaNumberKey, VALUE extends SchemaNumberValue>
implements IndexReader {
    private final GBPTree<KEY, VALUE> tree;
    private final Layout<KEY, VALUE> layout;
    private final KEY treeKeyFrom;
    private final KEY treeKeyTo;
    private Set<RawCursor<Hit<KEY, VALUE>, IOException>> openSeekers;

    NativeSchemaNumberIndexReader(GBPTree<KEY, VALUE> tree, Layout<KEY, VALUE> layout) {
        this.tree = tree;
        this.layout = layout;
        this.treeKeyFrom = (SchemaNumberKey)((Object)layout.newKey());
        this.treeKeyTo = (SchemaNumberKey)((Object)layout.newKey());
        this.openSeekers = new HashSet<RawCursor<Hit<KEY, VALUE>, IOException>>();
    }

    public void close() {
        this.ensureOpenSeekersClosed();
    }

    @Override
    public IndexSampler createSampler() {
        IndexSamplingConfig indexSamplingConfig = new IndexSamplingConfig(Config.defaults());
        FullScanNonUniqueIndexSampler<KEY, VALUE> sampler = new FullScanNonUniqueIndexSampler<KEY, VALUE>(this.tree, this.layout, indexSamplingConfig);
        return sampler::result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public long countIndexedNodes(long nodeId, Value ... propertyValues) {
        ((SchemaNumberKey)((Object)this.treeKeyFrom)).from(nodeId, propertyValues);
        ((SchemaNumberKey)((Object)this.treeKeyTo)).from(nodeId, propertyValues);
        try (RawCursor seeker = this.tree.seek(this.treeKeyFrom, this.treeKeyTo);){
            long count = 0L;
            while (seeker.next()) {
                if (((SchemaNumberKey)((Object)((Hit)seeker.get()).key())).entityId != nodeId) continue;
                ++count;
            }
            long l = count;
            return l;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public PrimitiveLongIterator query(IndexQuery ... predicates) throws IndexNotApplicableKernelException {
        if (predicates.length != 1) {
            throw new UnsupportedOperationException();
        }
        IndexQuery predicate = predicates[0];
        switch (predicate.type()) {
            case exists: {
                ((SchemaNumberKey)((Object)this.treeKeyFrom)).initAsLowest();
                ((SchemaNumberKey)((Object)this.treeKeyTo)).initAsHighest();
                return this.startSeekForInitializedRange();
            }
            case exact: {
                IndexQuery.ExactPredicate exactPredicate = (IndexQuery.ExactPredicate)predicate;
                Value[] values = new Value[]{exactPredicate.value()};
                ((SchemaNumberKey)((Object)this.treeKeyFrom)).from(Long.MIN_VALUE, values);
                ((SchemaNumberKey)((Object)this.treeKeyTo)).from(Long.MAX_VALUE, values);
                return this.startSeekForInitializedRange();
            }
            case rangeNumeric: {
                IndexQuery.NumberRangePredicate rangePredicate = (IndexQuery.NumberRangePredicate)predicate;
                ((SchemaNumberKey)((Object)this.treeKeyFrom)).from(rangePredicate.fromInclusive() ? Long.MIN_VALUE : Long.MAX_VALUE, Values.of((Object)rangePredicate.from()));
                ((SchemaNumberKey)((Object)this.treeKeyFrom)).entityIdIsSpecialTieBreaker = true;
                ((SchemaNumberKey)((Object)this.treeKeyTo)).from(rangePredicate.toInclusive() ? Long.MAX_VALUE : Long.MIN_VALUE, Values.of((Object)rangePredicate.to()));
                ((SchemaNumberKey)((Object)this.treeKeyTo)).entityIdIsSpecialTieBreaker = true;
                return this.startSeekForInitializedRange();
            }
        }
        throw new IllegalArgumentException("IndexQuery of type " + (Object)((Object)predicate.type()) + " is not supported.");
    }

    @Override
    public boolean hasFullNumberPrecision() {
        return true;
    }

    private PrimitiveLongIterator startSeekForInitializedRange() {
        try {
            RawCursor seeker = this.tree.seek(this.treeKeyFrom, this.treeKeyTo);
            this.openSeekers.add(seeker);
            return new NumberHitIterator<KEY, VALUE>(seeker, this.openSeekers);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private void ensureOpenSeekersClosed() {
        try {
            IOUtils.closeAll(this.openSeekers);
            this.openSeekers.clear();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

