/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.state;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Predicate;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.kernel.api.exceptions.schema.ConstraintValidationException;
import org.neo4j.kernel.api.properties.PropertyKeyValue;
import org.neo4j.kernel.impl.util.VersionedHashMap;
import org.neo4j.storageengine.api.StorageProperty;
import org.neo4j.storageengine.api.txstate.PropertyContainerState;
import org.neo4j.values.storable.Value;

public class PropertyContainerStateImpl
implements PropertyContainerState {
    private final long id;
    private VersionedHashMap<Integer, Value> addedProperties;
    private VersionedHashMap<Integer, Value> changedProperties;
    private VersionedHashMap<Integer, Value> removedProperties;
    private final Predicate<StorageProperty> excludePropertiesWeKnowAbout = new Predicate<StorageProperty>(){

        @Override
        public boolean test(StorageProperty item) {
            return !(PropertyContainerStateImpl.this.removedProperties != null && PropertyContainerStateImpl.this.removedProperties.containsKey(item.propertyKeyId()) || PropertyContainerStateImpl.this.addedProperties != null && PropertyContainerStateImpl.this.addedProperties.containsKey(item.propertyKeyId()) || PropertyContainerStateImpl.this.changedProperties != null && PropertyContainerStateImpl.this.changedProperties.containsKey(item.propertyKeyId()));
        }
    };

    PropertyContainerStateImpl(long id) {
        this.id = id;
    }

    public long getId() {
        return this.id;
    }

    public void clear() {
        if (this.changedProperties != null) {
            this.changedProperties.clear();
        }
        if (this.addedProperties != null) {
            this.addedProperties.clear();
        }
        if (this.removedProperties != null) {
            this.removedProperties.clear();
        }
    }

    public void changeProperty(int propertyKeyId, Value value) {
        if (this.addedProperties != null && this.addedProperties.containsKey(propertyKeyId)) {
            this.addedProperties.put(propertyKeyId, value);
            return;
        }
        if (this.changedProperties == null) {
            this.changedProperties = new VersionedHashMap();
        }
        this.changedProperties.put(propertyKeyId, value);
        if (this.removedProperties != null) {
            this.removedProperties.remove(propertyKeyId);
        }
    }

    public void addProperty(int propertyKeyId, Value value) {
        Value removed;
        if (this.removedProperties != null && (removed = this.removedProperties.remove(propertyKeyId)) != null) {
            this.changeProperty(propertyKeyId, value);
            return;
        }
        if (this.addedProperties == null) {
            this.addedProperties = new VersionedHashMap();
        }
        this.addedProperties.put(propertyKeyId, value);
    }

    public void removeProperty(int propertyKeyId, Value value) {
        if (this.addedProperties != null && this.addedProperties.remove(propertyKeyId) != null) {
            return;
        }
        if (this.removedProperties == null) {
            this.removedProperties = new VersionedHashMap();
        }
        this.removedProperties.put(propertyKeyId, value);
        if (this.changedProperties != null) {
            this.changedProperties.remove(propertyKeyId);
        }
    }

    @Override
    public Iterator<StorageProperty> addedProperties() {
        return this.toPropertyIterator(this.addedProperties);
    }

    @Override
    public Iterator<StorageProperty> changedProperties() {
        return this.toPropertyIterator(this.changedProperties);
    }

    @Override
    public Iterator<Integer> removedProperties() {
        return this.removedProperties != null ? this.removedProperties.keySet().iterator() : Collections.emptyIterator();
    }

    @Override
    public Iterator<StorageProperty> addedAndChangedProperties() {
        if (this.addedProperties == null) {
            return this.toPropertyIterator(this.changedProperties);
        }
        if (this.changedProperties == null) {
            return this.toPropertyIterator(this.addedProperties);
        }
        return Iterators.concat((Iterator[])new Iterator[]{this.toPropertyIterator(this.addedProperties), this.toPropertyIterator(this.changedProperties)});
    }

    @Override
    public Iterator<StorageProperty> augmentProperties(Iterator<StorageProperty> iterator) {
        if (this.removedProperties != null || this.addedProperties != null || this.changedProperties != null) {
            iterator = Iterators.filter(this.excludePropertiesWeKnowAbout, iterator);
            if (this.addedProperties != null && !this.addedProperties.isEmpty()) {
                iterator = Iterators.concat((Iterator[])new Iterator[]{iterator, this.toPropertyIterator(this.addedProperties)});
            }
            if (this.changedProperties != null && !this.changedProperties.isEmpty()) {
                iterator = Iterators.concat((Iterator[])new Iterator[]{iterator, this.toPropertyIterator(this.changedProperties)});
            }
        }
        return iterator;
    }

    @Override
    public void accept(PropertyContainerState.Visitor visitor) throws ConstraintValidationException {
        if (this.addedProperties != null || this.removedProperties != null || this.changedProperties != null) {
            visitor.visitPropertyChanges(this.id, this.addedProperties(), this.changedProperties(), this.removedProperties());
        }
    }

    @Override
    public boolean hasChanges() {
        return this.addedProperties != null || this.removedProperties != null || this.changedProperties != null;
    }

    @Override
    public StorageProperty getChangedProperty(int propertyKeyId) {
        return this.changedProperties == null ? null : this.getPropertyOrNull(this.changedProperties, propertyKeyId);
    }

    @Override
    public StorageProperty getAddedProperty(int propertyKeyId) {
        return this.addedProperties == null ? null : this.getPropertyOrNull(this.addedProperties, propertyKeyId);
    }

    @Override
    public boolean isPropertyRemoved(int propertyKeyId) {
        return this.removedProperties != null && this.removedProperties.containsKey(propertyKeyId);
    }

    private Iterator<StorageProperty> toPropertyIterator(VersionedHashMap<Integer, Value> propertyMap) {
        return propertyMap == null ? Collections.emptyIterator() : Iterators.map(entry -> new PropertyKeyValue((Integer)entry.getKey(), (Value)entry.getValue()), propertyMap.entrySet().iterator());
    }

    private PropertyKeyValue getPropertyOrNull(VersionedHashMap<Integer, Value> propertyMap, int propertyKeyId) {
        Value value = propertyMap.get(propertyKeyId);
        return value == null ? null : new PropertyKeyValue(propertyKeyId, value);
    }
}

