/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.function.Predicate;
import org.neo4j.collection.primitive.Primitive;
import org.neo4j.collection.primitive.PrimitiveIntSet;
import org.neo4j.collection.primitive.PrimitiveLongIterator;
import org.neo4j.helpers.Exceptions;
import org.neo4j.helpers.Format;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.api.CountsAccessor;
import org.neo4j.kernel.impl.logging.LogService;
import org.neo4j.kernel.impl.store.RecordStore;
import org.neo4j.kernel.impl.store.RelationshipStore;
import org.neo4j.kernel.impl.store.format.RecordFormatSelector;
import org.neo4j.kernel.impl.store.format.RecordFormats;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;
import org.neo4j.kernel.impl.storemigration.monitoring.SilentMigrationProgressMonitor;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.unsafe.impl.batchimport.AdditionalInitialIds;
import org.neo4j.unsafe.impl.batchimport.BatchImporter;
import org.neo4j.unsafe.impl.batchimport.Configuration;
import org.neo4j.unsafe.impl.batchimport.CountingStoreUpdateMonitor;
import org.neo4j.unsafe.impl.batchimport.DeleteDuplicateNodesStage;
import org.neo4j.unsafe.impl.batchimport.IdMapperPreparationStage;
import org.neo4j.unsafe.impl.batchimport.InputIterable;
import org.neo4j.unsafe.impl.batchimport.MemoryUsageStatsProvider;
import org.neo4j.unsafe.impl.batchimport.NodeCountsStage;
import org.neo4j.unsafe.impl.batchimport.NodeStage;
import org.neo4j.unsafe.impl.batchimport.RelationshipCountsStage;
import org.neo4j.unsafe.impl.batchimport.RelationshipGroupDefragmenter;
import org.neo4j.unsafe.impl.batchimport.RelationshipGroupStage;
import org.neo4j.unsafe.impl.batchimport.RelationshipLinkbackStage;
import org.neo4j.unsafe.impl.batchimport.RelationshipLinkforwardStage;
import org.neo4j.unsafe.impl.batchimport.RelationshipStage;
import org.neo4j.unsafe.impl.batchimport.RelationshipTypeDistribution;
import org.neo4j.unsafe.impl.batchimport.SourceOrCachedInputIterable;
import org.neo4j.unsafe.impl.batchimport.SparseNodeFirstRelationshipStage;
import org.neo4j.unsafe.impl.batchimport.cache.GatheringMemoryStatsVisitor;
import org.neo4j.unsafe.impl.batchimport.cache.MemoryStatsVisitor;
import org.neo4j.unsafe.impl.batchimport.cache.NodeLabelsCache;
import org.neo4j.unsafe.impl.batchimport.cache.NodeRelationshipCache;
import org.neo4j.unsafe.impl.batchimport.cache.NumberArrayFactory;
import org.neo4j.unsafe.impl.batchimport.cache.idmapping.IdGenerator;
import org.neo4j.unsafe.impl.batchimport.cache.idmapping.IdMapper;
import org.neo4j.unsafe.impl.batchimport.input.Collector;
import org.neo4j.unsafe.impl.batchimport.input.Input;
import org.neo4j.unsafe.impl.batchimport.input.InputCache;
import org.neo4j.unsafe.impl.batchimport.input.InputNode;
import org.neo4j.unsafe.impl.batchimport.input.InputRelationship;
import org.neo4j.unsafe.impl.batchimport.staging.ExecutionMonitor;
import org.neo4j.unsafe.impl.batchimport.staging.ExecutionSupervisors;
import org.neo4j.unsafe.impl.batchimport.staging.Stage;
import org.neo4j.unsafe.impl.batchimport.store.BatchingNeoStores;
import org.neo4j.unsafe.impl.batchimport.store.BatchingTokenRepository;
import org.neo4j.unsafe.impl.batchimport.store.io.IoMonitor;

public class ParallelBatchImporter
implements BatchImporter {
    private final File storeDir;
    private final FileSystemAbstraction fileSystem;
    private final Configuration config;
    private final LogService logService;
    private final Log log;
    private final ExecutionMonitor executionMonitor;
    private final AdditionalInitialIds additionalInitialIds;
    private final Config dbConfig;
    private final RecordFormats recordFormats;
    private final PageCache pageCache;

    public ParallelBatchImporter(File storeDir, FileSystemAbstraction fileSystem, Configuration config, LogService logService, ExecutionMonitor executionMonitor, AdditionalInitialIds additionalInitialIds, Config dbConfig, RecordFormats recordFormats) {
        this.storeDir = storeDir;
        this.fileSystem = fileSystem;
        this.pageCache = null;
        this.config = config;
        this.logService = logService;
        this.dbConfig = dbConfig;
        this.recordFormats = recordFormats;
        this.log = logService.getInternalLogProvider().getLog(this.getClass());
        this.executionMonitor = executionMonitor;
        this.additionalInitialIds = additionalInitialIds;
    }

    public ParallelBatchImporter(File storeDir, FileSystemAbstraction fileSystem, PageCache pageCache, Configuration config, LogService logService, ExecutionMonitor executionMonitor, AdditionalInitialIds additionalInitialIds, Config dbConfig, RecordFormats recordFormats) {
        this.pageCache = pageCache;
        this.storeDir = storeDir;
        this.fileSystem = fileSystem;
        this.config = config;
        this.logService = logService;
        this.dbConfig = dbConfig;
        this.recordFormats = recordFormats;
        this.log = logService.getInternalLogProvider().getLog(this.getClass());
        this.executionMonitor = executionMonitor;
        this.additionalInitialIds = additionalInitialIds;
    }

    public ParallelBatchImporter(File storeDir, FileSystemAbstraction fileSystem, Configuration config, LogService logService, ExecutionMonitor executionMonitor, Config dbConfig) {
        this(storeDir, fileSystem, config, logService, ExecutionSupervisors.withDynamicProcessorAssignment(executionMonitor, config), AdditionalInitialIds.EMPTY, dbConfig, RecordFormatSelector.selectForConfig(dbConfig, (LogProvider)NullLogProvider.getInstance()));
    }

    @Override
    public void doImport(Input input) throws IOException {
        this.log.info("Import starting");
        long maxMemory = this.config.maxMemoryUsage();
        NodeRelationshipCache nodeRelationshipCache = null;
        NodeLabelsCache nodeLabelsCache = null;
        long startTime = System.currentTimeMillis();
        CountingStoreUpdateMonitor storeUpdateMonitor = new CountingStoreUpdateMonitor();
        try (BatchingNeoStores neoStore = this.getBatchingNeoStores();
             CountsAccessor.Updater countsUpdater = neoStore.getCountsStore().reset(neoStore.getLastCommittedTransactionId());
             InputCache inputCache = new InputCache(this.fileSystem, this.storeDir, this.recordFormats, this.config);){
            NumberArrayFactory numberArrayFactory = NumberArrayFactory.auto(this.pageCache, this.storeDir);
            Collector badCollector = input.badCollector();
            IoMonitor writeMonitor = new IoMonitor(neoStore.getIoTracer());
            IdMapper idMapper = input.idMapper(numberArrayFactory);
            IdGenerator idGenerator = input.idGenerator();
            nodeRelationshipCache = new NodeRelationshipCache(numberArrayFactory, this.config.denseNodeThreshold());
            MemoryUsageStatsProvider memoryUsageStats = new MemoryUsageStatsProvider(nodeRelationshipCache, idMapper);
            InputIterable<InputNode> nodes = input.nodes();
            InputIterable<InputRelationship> relationships = input.relationships();
            InputIterable<InputNode> cachedNodes = SourceOrCachedInputIterable.cachedForSure(nodes, inputCache.nodes("main", true));
            RelationshipStore relationshipStore = neoStore.getRelationshipStore();
            Configuration nodeConfig = ParallelBatchImporter.configWithRecordsPerPageBasedBatchSize(this.config, neoStore.getNodeStore());
            NodeStage nodeStage = new NodeStage(nodeConfig, writeMonitor, nodes, idMapper, idGenerator, neoStore, inputCache, neoStore.getLabelScanStore(), storeUpdateMonitor, nodeRelationshipCache, memoryUsageStats);
            neoStore.startFlushingPageCache();
            this.executeStage(nodeStage);
            neoStore.stopFlushingPageCache();
            if (idMapper.needsPreparation()) {
                this.executeStage(new IdMapperPreparationStage(this.config, idMapper, cachedNodes, badCollector, memoryUsageStats));
                PrimitiveLongIterator duplicateNodeIds = badCollector.leftOverDuplicateNodesIds();
                if (duplicateNodeIds.hasNext()) {
                    this.executeStage(new DeleteDuplicateNodesStage(this.config, duplicateNodeIds, neoStore));
                }
            }
            Configuration relationshipConfig = ParallelBatchImporter.configWithRecordsPerPageBasedBatchSize(this.config, neoStore.getNodeStore());
            RelationshipStage unlinkedRelationshipStage = new RelationshipStage(relationshipConfig, writeMonitor, relationships, idMapper, badCollector, inputCache, nodeRelationshipCache, neoStore, storeUpdateMonitor);
            neoStore.startFlushingPageCache();
            this.executeStage(unlinkedRelationshipStage);
            neoStore.stopFlushingPageCache();
            long availableMemory = maxMemory - this.totalMemoryUsageOf(nodeRelationshipCache, idMapper, neoStore);
            this.linkData(nodeRelationshipCache, neoStore, unlinkedRelationshipStage.getDistribution(), availableMemory);
            long peakMemoryUsage = this.totalMemoryUsageOf(nodeRelationshipCache, idMapper, neoStore);
            long highNodeId = nodeRelationshipCache.getHighNodeId();
            idMapper.close();
            idMapper = null;
            nodeRelationshipCache.close();
            nodeRelationshipCache = null;
            RelationshipGroupDefragmenter groupDefragmenter = new RelationshipGroupDefragmenter(this.config, this.executionMonitor, numberArrayFactory);
            groupDefragmenter.run(Long.max(maxMemory, peakMemoryUsage), neoStore, highNodeId);
            SilentMigrationProgressMonitor progressMonitor = new SilentMigrationProgressMonitor();
            nodeLabelsCache = new NodeLabelsCache(numberArrayFactory, neoStore.getLabelRepository().getHighId());
            memoryUsageStats = new MemoryUsageStatsProvider(nodeLabelsCache);
            this.executeStage(new NodeCountsStage(this.config, nodeLabelsCache, neoStore.getNodeStore(), neoStore.getLabelRepository().getHighId(), countsUpdater, progressMonitor.startSection("Nodes"), memoryUsageStats));
            this.executeStage(new RelationshipCountsStage(this.config, nodeLabelsCache, relationshipStore, neoStore.getLabelRepository().getHighId(), neoStore.getRelationshipTypeRepository().getHighId(), countsUpdater, numberArrayFactory, progressMonitor.startSection("Relationships")));
            long totalTimeMillis = System.currentTimeMillis() - startTime;
            this.executionMonitor.done(totalTimeMillis, String.format("%n", new Object[0]) + storeUpdateMonitor.toString() + String.format("%n", new Object[0]) + "Peak memory usage: " + Format.bytes(peakMemoryUsage));
            this.log.info("Import completed, took " + Format.duration(totalTimeMillis) + ". " + storeUpdateMonitor);
        }
        catch (Throwable t) {
            this.log.error("Error during import", t);
            throw (IOException)Exceptions.launderedException(IOException.class, (Throwable)t);
        }
        finally {
            if (nodeRelationshipCache != null) {
                nodeRelationshipCache.close();
            }
            if (nodeLabelsCache != null) {
                nodeLabelsCache.close();
            }
        }
    }

    private BatchingNeoStores getBatchingNeoStores() {
        if (this.pageCache == null) {
            return BatchingNeoStores.batchingNeoStores(this.fileSystem, this.storeDir, this.recordFormats, this.config, this.logService, this.additionalInitialIds, this.dbConfig);
        }
        return BatchingNeoStores.batchingNeoStoresWithExternalPageCache(this.fileSystem, this.pageCache, PageCacheTracer.NULL, this.storeDir, this.recordFormats, this.config, this.logService, this.additionalInitialIds, this.dbConfig);
    }

    private long totalMemoryUsageOf(MemoryStatsVisitor.Visitable ... users) {
        GatheringMemoryStatsVisitor total = new GatheringMemoryStatsVisitor();
        for (MemoryStatsVisitor.Visitable user : users) {
            user.acceptMemoryStatsVisitor(total);
        }
        return total.getHeapUsage() + total.getOffHeapUsage();
    }

    private void linkData(NodeRelationshipCache nodeRelationshipCache, BatchingNeoStores neoStore, RelationshipTypeDistribution typeDistribution, long freeMemoryForDenseNodeCache) {
        Configuration relationshipConfig = ParallelBatchImporter.configWithRecordsPerPageBasedBatchSize(this.config, neoStore.getRelationshipStore());
        Configuration nodeConfig = ParallelBatchImporter.configWithRecordsPerPageBasedBatchSize(this.config, neoStore.getNodeStore());
        Iterator<Collection<Object>> rounds = nodeRelationshipCache.splitRelationshipTypesIntoRounds(typeDistribution.iterator(), freeMemoryForDenseNodeCache);
        Configuration groupConfig = ParallelBatchImporter.configWithRecordsPerPageBasedBatchSize(this.config, neoStore.getRelationshipGroupStore());
        int typesImported = 0;
        int round = 0;
        round = 0;
        while (rounds.hasNext()) {
            Collection<Object> typesToLinkThisRound = rounds.next();
            boolean thisIsTheFirstRound = round == 0;
            boolean thisIsTheOnlyRound = thisIsTheFirstRound && !rounds.hasNext();
            nodeRelationshipCache.setForwardScan(true, true);
            String range = typesToLinkThisRound.size() == 1 ? String.valueOf(typesImported + 1) : typesImported + 1 + "-" + (typesImported + typesToLinkThisRound.size());
            String topic = " " + range + "/" + typeDistribution.getNumberOfRelationshipTypes();
            int nodeTypes = thisIsTheFirstRound ? 3 : 1;
            Predicate<RelationshipRecord> readFilter = thisIsTheFirstRound ? null : ParallelBatchImporter.typeIdFilter(typesToLinkThisRound, neoStore.getRelationshipTypeRepository());
            Predicate<RelationshipRecord> denseChangeFilter = thisIsTheOnlyRound ? null : ParallelBatchImporter.typeIdFilter(typesToLinkThisRound, neoStore.getRelationshipTypeRepository());
            RelationshipLinkforwardStage linkForwardStage = new RelationshipLinkforwardStage(topic, relationshipConfig, neoStore.getRelationshipStore(), nodeRelationshipCache, readFilter, denseChangeFilter, nodeTypes);
            this.executeStage(linkForwardStage);
            this.executeStage(new RelationshipGroupStage(topic, groupConfig, neoStore.getTemporaryRelationshipGroupStore(), nodeRelationshipCache));
            if (thisIsTheFirstRound) {
                this.executeStage(new SparseNodeFirstRelationshipStage(nodeConfig, neoStore.getNodeStore(), nodeRelationshipCache));
            }
            nodeRelationshipCache.setForwardScan(false, true);
            this.executeStage(new RelationshipLinkbackStage(topic, relationshipConfig, neoStore.getRelationshipStore(), nodeRelationshipCache, readFilter, denseChangeFilter, nodeTypes));
            typesImported += typesToLinkThisRound.size();
            ++round;
        }
    }

    private static Predicate<RelationshipRecord> typeIdFilter(Collection<Object> typesToLinkThisRound, BatchingTokenRepository.BatchingRelationshipTypeTokenRepository relationshipTypeRepository) {
        PrimitiveIntSet set = Primitive.intSet((int)typesToLinkThisRound.size());
        for (Object type : typesToLinkThisRound) {
            int id = type instanceof Number ? ((Number)type).intValue() : relationshipTypeRepository.applyAsInt(type);
            set.add(id);
        }
        return relationship -> set.contains(relationship.getType());
    }

    private static Configuration configWithRecordsPerPageBasedBatchSize(Configuration source, RecordStore<?> store) {
        return Configuration.withBatchSize(source, store.getRecordsPerPage() * 10);
    }

    private void executeStage(Stage stage) {
        ExecutionSupervisors.superviseExecution(this.executionMonitor, this.config, stage);
    }
}

