/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.labelscan;

import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.NoSuchFileException;
import java.util.Iterator;
import java.util.function.Consumer;
import java.util.function.IntFunction;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.neo4j.cursor.RawCursor;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.helpers.Format;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.index.internal.gbptree.GBPTree;
import org.neo4j.index.internal.gbptree.Header;
import org.neo4j.index.internal.gbptree.Hit;
import org.neo4j.index.internal.gbptree.Layout;
import org.neo4j.index.internal.gbptree.MetadataMismatchException;
import org.neo4j.index.internal.gbptree.RecoveryCleanupWorkCollector;
import org.neo4j.index.internal.gbptree.Writer;
import org.neo4j.io.pagecache.IOLimiter;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.kernel.api.labelscan.AllEntriesLabelScanReader;
import org.neo4j.kernel.api.labelscan.LabelScanStore;
import org.neo4j.kernel.api.labelscan.LabelScanWriter;
import org.neo4j.kernel.impl.api.scan.FullStoreChangeStream;
import org.neo4j.kernel.impl.index.GBPTreeUtil;
import org.neo4j.kernel.impl.index.labelscan.LabelScanKey;
import org.neo4j.kernel.impl.index.labelscan.LabelScanLayout;
import org.neo4j.kernel.impl.index.labelscan.LabelScanValue;
import org.neo4j.kernel.impl.index.labelscan.NativeAllEntriesLabelScanReader;
import org.neo4j.kernel.impl.index.labelscan.NativeLabelScanReader;
import org.neo4j.kernel.impl.index.labelscan.NativeLabelScanWriter;
import org.neo4j.kernel.impl.store.UnderlyingStorageException;
import org.neo4j.kernel.monitoring.Monitors;
import org.neo4j.storageengine.api.schema.LabelScanReader;

public class NativeLabelScanStore
implements LabelScanStore {
    public static final String FILE_NAME = "neostore.labelscanstore.db";
    private static final byte CLEAN = 0;
    private static final byte NEEDS_REBUILDING = 1;
    private final boolean readOnly;
    private final LabelScanStore.Monitor monitor;
    private final Monitors monitors;
    private final PageCache pageCache;
    private final File storeFile;
    private final FullStoreChangeStream fullStoreChangeStream;
    private final int pageSize;
    private GBPTree<LabelScanKey, LabelScanValue> index;
    private boolean needsRebuild;
    private final RecoveryCleanupWorkCollector recoveryCleanupWorkCollector;
    private final NativeLabelScanWriter singleWriter;
    private static final Consumer<PageCursor> needsRebuildingWriter = pageCursor -> pageCursor.putByte((byte)1);
    private static final Consumer<PageCursor> writeClean = pageCursor -> pageCursor.putByte((byte)0);

    public NativeLabelScanStore(PageCache pageCache, File storeDir, FullStoreChangeStream fullStoreChangeStream, boolean readOnly, Monitors monitors, RecoveryCleanupWorkCollector recoveryCleanupWorkCollector) {
        this(pageCache, storeDir, fullStoreChangeStream, readOnly, monitors, recoveryCleanupWorkCollector, 0);
    }

    NativeLabelScanStore(PageCache pageCache, File storeDir, FullStoreChangeStream fullStoreChangeStream, boolean readOnly, Monitors monitors, RecoveryCleanupWorkCollector recoveryCleanupWorkCollector, int pageSize) {
        this.pageCache = pageCache;
        this.pageSize = pageSize;
        this.fullStoreChangeStream = fullStoreChangeStream;
        this.storeFile = new File(storeDir, FILE_NAME);
        this.singleWriter = new NativeLabelScanWriter(1000);
        this.readOnly = readOnly;
        this.monitors = monitors;
        this.monitor = monitors.newMonitor(LabelScanStore.Monitor.class, new String[0]);
        this.recoveryCleanupWorkCollector = recoveryCleanupWorkCollector;
    }

    @Override
    public LabelScanReader newReader() {
        return new NativeLabelScanReader(this.index);
    }

    @Override
    public LabelScanWriter newWriter() {
        if (this.readOnly) {
            throw new UnsupportedOperationException("Can't create index writer in read only mode.");
        }
        try {
            return this.writer();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public void force(IOLimiter limiter) throws UnderlyingStorageException {
        try {
            this.index.checkpoint(limiter);
        }
        catch (IOException e) {
            throw new UnderlyingStorageException(e);
        }
    }

    @Override
    public AllEntriesLabelScanReader allNodeLabelRanges() {
        IntFunction<RawCursor<Hit<LabelScanKey, LabelScanValue>, IOException>> seekProvider = labelId -> {
            try {
                return this.index.seek((Object)new LabelScanKey().set(labelId, 0L), (Object)new LabelScanKey().set(labelId, Long.MAX_VALUE));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        };
        int highestLabelId = -1;
        try (RawCursor cursor = this.index.seek((Object)new LabelScanKey().set(Integer.MAX_VALUE, Long.MAX_VALUE), (Object)new LabelScanKey().set(0, -1L));){
            if (cursor.next()) {
                highestLabelId = ((LabelScanKey)((Hit)cursor.get()).key()).labelId;
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return new NativeAllEntriesLabelScanReader(seekProvider, highestLabelId);
    }

    @Override
    public ResourceIterator<File> snapshotStoreFiles() throws IOException {
        return Iterators.asResourceIterator((Iterator)Iterators.iterator((Object)this.storeFile));
    }

    @Override
    public void init() throws IOException {
        boolean isDirty;
        this.monitor.init();
        boolean storeExists = this.hasStore();
        try {
            boolean bl = this.needsRebuild = !storeExists;
            if (!storeExists) {
                this.monitor.noIndex();
            }
            isDirty = this.instantiateTree();
        }
        catch (MetadataMismatchException e) {
            isDirty = true;
        }
        if (isDirty) {
            this.monitor.notValidIndex();
            this.dropStrict();
            this.instantiateTree();
            this.needsRebuild = true;
        }
    }

    @Override
    public boolean hasStore() throws IOException {
        return GBPTreeUtil.storeFileExists(this.pageCache, this.storeFile);
    }

    @Override
    public File getLabelScanStoreFile() {
        return this.storeFile;
    }

    private boolean instantiateTree() throws IOException {
        this.monitors.addMonitorListener(this.treeMonitor(), new String[0]);
        GBPTree.Monitor monitor = this.monitors.newMonitor(GBPTree.Monitor.class, new String[0]);
        MutableBoolean isRebuilding = new MutableBoolean();
        Header.Reader readRebuilding = headerData -> isRebuilding.setValue(headerData.get() == 1);
        this.index = new GBPTree(this.pageCache, this.storeFile, (Layout)new LabelScanLayout(), this.pageSize, monitor, readRebuilding, needsRebuildingWriter, this.recoveryCleanupWorkCollector);
        return isRebuilding.getValue();
    }

    private GBPTree.Monitor treeMonitor() {
        return new GBPTree.Monitor.Adaptor(){

            public void cleanupFinished(long numberOfPagesVisited, long numberOfCleanedCrashPointers, long durationMillis) {
                NativeLabelScanStore.this.monitor.recoveryCompleted(MapUtil.map((Object[])new Object[]{"Number of pages visited", numberOfPagesVisited, "Number of cleaned crashed pointers", numberOfCleanedCrashPointers, "Time spent", Format.duration(durationMillis)}));
            }
        };
    }

    @Override
    public void drop() throws IOException {
        try {
            this.dropStrict();
        }
        catch (NoSuchFileException noSuchFileException) {
            // empty catch block
        }
    }

    private void dropStrict() throws IOException {
        if (this.index != null) {
            this.index.close();
            this.index = null;
        }
        GBPTreeUtil.delete(this.pageCache, this.storeFile);
    }

    @Override
    public void start() throws IOException {
        if (this.needsRebuild) {
            long numberOfNodes;
            this.monitor.rebuilding();
            try (NativeLabelScanWriter writer = this.writer();){
                numberOfNodes = this.fullStoreChangeStream.applyTo(writer);
            }
            this.index.checkpoint(IOLimiter.unlimited(), writeClean);
            this.monitor.rebuilt(numberOfNodes);
            this.needsRebuild = false;
        }
    }

    private NativeLabelScanWriter writer() throws IOException {
        return this.singleWriter.initialize((Writer<LabelScanKey, LabelScanValue>)this.index.writer());
    }

    @Override
    public boolean isEmpty() throws IOException {
        try (RawCursor cursor = this.index.seek((Object)new LabelScanKey(0, 0L), (Object)new LabelScanKey(Integer.MAX_VALUE, Long.MAX_VALUE));){
            boolean bl = !cursor.next();
            return bl;
        }
    }

    @Override
    public void stop() throws IOException {
    }

    @Override
    public void shutdown() throws IOException {
        this.index.close();
    }

    @Override
    public boolean isReadOnly() {
        return this.readOnly;
    }
}

