/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.exceptions.index;

import org.neo4j.kernel.api.TokenNameLookup;
import org.neo4j.kernel.api.schema.LabelSchemaDescriptor;
import org.neo4j.kernel.api.schema.SchemaUtil;
import org.neo4j.kernel.api.schema.index.IndexDescriptor;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.ValueTuple;

public class IndexEntryConflictException
extends Exception {
    private final ValueTuple propertyValues;
    private final long addedNodeId;
    private final long existingNodeId;

    public IndexEntryConflictException(long existingNodeId, long addedNodeId, Value propertyValue) {
        this(existingNodeId, addedNodeId, ValueTuple.of((Value[])new Value[]{propertyValue}));
    }

    public IndexEntryConflictException(long existingNodeId, long addedNodeId, ValueTuple propertyValues) {
        super(String.format("Both node %d and node %d share the property value %s", existingNodeId, addedNodeId, propertyValues));
        this.existingNodeId = existingNodeId;
        this.addedNodeId = addedNodeId;
        this.propertyValues = propertyValues;
    }

    public RuntimeException notAllowed(IndexDescriptor descriptor) {
        return new IllegalStateException(String.format("Index for (%s) should not require unique values.", descriptor.userDescription(SchemaUtil.idTokenNameLookup)), this);
    }

    public String evidenceMessage(TokenNameLookup tokenNameLookup, LabelSchemaDescriptor schema) {
        assert (schema.getPropertyIds().length == this.propertyValues.size());
        String labelName = tokenNameLookup.labelGetName(schema.getLabelId());
        if (this.addedNodeId == -1L) {
            return String.format("Node(%d) already exists with label `%s` and %s", this.existingNodeId, labelName, this.propertyString(tokenNameLookup, schema.getPropertyIds()));
        }
        return String.format("Both Node(%d) and Node(%d) have the label `%s` and %s", this.existingNodeId, this.addedNodeId, labelName, this.propertyString(tokenNameLookup, schema.getPropertyIds()));
    }

    public ValueTuple getPropertyValues() {
        return this.propertyValues;
    }

    public Value getSinglePropertyValue() {
        return this.propertyValues.getOnlyValue();
    }

    public long getAddedNodeId() {
        return this.addedNodeId;
    }

    public long getExistingNodeId() {
        return this.existingNodeId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IndexEntryConflictException that = (IndexEntryConflictException)o;
        return this.addedNodeId == that.addedNodeId && this.existingNodeId == that.existingNodeId && !(this.propertyValues == null ? that.propertyValues != null : !this.propertyValues.equals((Object)that.propertyValues));
    }

    public int hashCode() {
        int result = this.propertyValues != null ? this.propertyValues.hashCode() : 0;
        result = 31 * result + (int)(this.addedNodeId ^ this.addedNodeId >>> 32);
        result = 31 * result + (int)(this.existingNodeId ^ this.existingNodeId >>> 32);
        return result;
    }

    @Override
    public String toString() {
        return "IndexEntryConflictException{propertyValues=" + this.propertyValues + ", addedNodeId=" + this.addedNodeId + ", existingNodeId=" + this.existingNodeId + '}';
    }

    private String propertyString(TokenNameLookup tokenNameLookup, int[] propertyIds) {
        StringBuilder sb = new StringBuilder();
        String sep = propertyIds.length > 1 ? "properties " : "property ";
        for (int i = 0; i < propertyIds.length; ++i) {
            sb.append(sep);
            sep = ", ";
            sb.append('`');
            sb.append(tokenNameLookup.propertyKeyGetName(propertyIds[i]));
            sb.append("` = ");
            sb.append(this.propertyValues.valueAt(i).prettyPrint());
        }
        return sb.toString();
    }
}

