/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api;

import java.util.Map;
import org.neo4j.kernel.api.exceptions.EntityNotFoundException;
import org.neo4j.kernel.api.exceptions.InvalidTransactionTypeKernelException;
import org.neo4j.kernel.api.exceptions.KernelException;
import org.neo4j.kernel.api.exceptions.RelationshipTypeIdNotFoundKernelException;
import org.neo4j.kernel.api.exceptions.legacyindex.AutoIndexingKernelException;
import org.neo4j.kernel.api.exceptions.legacyindex.LegacyIndexNotFoundKernelException;
import org.neo4j.kernel.api.exceptions.schema.ConstraintValidationException;
import org.neo4j.values.storable.Value;

public interface DataWriteOperations {
    public long nodeCreate();

    public void nodeDelete(long var1) throws EntityNotFoundException, InvalidTransactionTypeKernelException, AutoIndexingKernelException;

    public int nodeDetachDelete(long var1) throws KernelException;

    public long relationshipCreate(int var1, long var2, long var4) throws RelationshipTypeIdNotFoundKernelException, EntityNotFoundException;

    public void relationshipDelete(long var1) throws EntityNotFoundException, InvalidTransactionTypeKernelException, AutoIndexingKernelException;

    public boolean nodeAddLabel(long var1, int var3) throws EntityNotFoundException, ConstraintValidationException;

    public boolean nodeRemoveLabel(long var1, int var3) throws EntityNotFoundException;

    public Value nodeSetProperty(long var1, int var3, Value var4) throws EntityNotFoundException, AutoIndexingKernelException, InvalidTransactionTypeKernelException, ConstraintValidationException;

    public Value relationshipSetProperty(long var1, int var3, Value var4) throws EntityNotFoundException, AutoIndexingKernelException, InvalidTransactionTypeKernelException;

    public Value graphSetProperty(int var1, Value var2);

    public Value nodeRemoveProperty(long var1, int var3) throws EntityNotFoundException, AutoIndexingKernelException, InvalidTransactionTypeKernelException;

    public Value relationshipRemoveProperty(long var1, int var3) throws EntityNotFoundException, AutoIndexingKernelException, InvalidTransactionTypeKernelException;

    public Value graphRemoveProperty(int var1);

    public void nodeLegacyIndexCreateLazily(String var1, Map<String, String> var2);

    public void nodeLegacyIndexCreate(String var1, Map<String, String> var2);

    public void relationshipLegacyIndexCreateLazily(String var1, Map<String, String> var2);

    public void relationshipLegacyIndexCreate(String var1, Map<String, String> var2);

    public String nodeLegacyIndexSetConfiguration(String var1, String var2, String var3) throws LegacyIndexNotFoundKernelException;

    public String relationshipLegacyIndexSetConfiguration(String var1, String var2, String var3) throws LegacyIndexNotFoundKernelException;

    public String nodeLegacyIndexRemoveConfiguration(String var1, String var2) throws LegacyIndexNotFoundKernelException;

    public String relationshipLegacyIndexRemoveConfiguration(String var1, String var2) throws LegacyIndexNotFoundKernelException;

    public void nodeAddToLegacyIndex(String var1, long var2, String var4, Object var5) throws EntityNotFoundException, LegacyIndexNotFoundKernelException;

    public void nodeRemoveFromLegacyIndex(String var1, long var2, String var4, Object var5) throws LegacyIndexNotFoundKernelException;

    public void nodeRemoveFromLegacyIndex(String var1, long var2, String var4) throws LegacyIndexNotFoundKernelException;

    public void nodeRemoveFromLegacyIndex(String var1, long var2) throws LegacyIndexNotFoundKernelException;

    public void relationshipAddToLegacyIndex(String var1, long var2, String var4, Object var5) throws EntityNotFoundException, LegacyIndexNotFoundKernelException;

    public void relationshipRemoveFromLegacyIndex(String var1, long var2, String var4, Object var5) throws LegacyIndexNotFoundKernelException, EntityNotFoundException;

    public void relationshipRemoveFromLegacyIndex(String var1, long var2, String var4) throws LegacyIndexNotFoundKernelException, EntityNotFoundException;

    public void relationshipRemoveFromLegacyIndex(String var1, long var2) throws LegacyIndexNotFoundKernelException, EntityNotFoundException;

    public void nodeLegacyIndexDrop(String var1) throws LegacyIndexNotFoundKernelException;

    public void relationshipLegacyIndexDrop(String var1) throws LegacyIndexNotFoundKernelException;
}

