/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.neo4j.kernel.impl.api.CountsAccessor;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;
import org.neo4j.kernel.impl.storemigration.monitoring.MigrationProgressMonitor;
import org.neo4j.unsafe.impl.batchimport.Configuration;
import org.neo4j.unsafe.impl.batchimport.RelationshipCountsProcessor;
import org.neo4j.unsafe.impl.batchimport.cache.NodeLabelsCache;
import org.neo4j.unsafe.impl.batchimport.cache.NumberArrayFactory;
import org.neo4j.unsafe.impl.batchimport.staging.BatchSender;
import org.neo4j.unsafe.impl.batchimport.staging.ProcessorStep;
import org.neo4j.unsafe.impl.batchimport.staging.StageControl;
import org.neo4j.unsafe.impl.batchimport.stats.StatsProvider;

public class ProcessRelationshipCountsDataStep
extends ProcessorStep<RelationshipRecord[]> {
    private final NodeLabelsCache cache;
    private final Map<Thread, RelationshipCountsProcessor> processors = new ConcurrentHashMap<Thread, RelationshipCountsProcessor>();
    private final int highLabelId;
    private final int highRelationshipTypeId;
    private final CountsAccessor.Updater countsUpdater;
    private final NumberArrayFactory cacheFactory;
    private final MigrationProgressMonitor.Section progressMonitor;

    public ProcessRelationshipCountsDataStep(StageControl control, NodeLabelsCache cache, Configuration config, int highLabelId, int highRelationshipTypeId, CountsAccessor.Updater countsUpdater, NumberArrayFactory cacheFactory, MigrationProgressMonitor.Section progressMonitor) {
        super(control, "COUNT", config, 0, new StatsProvider[0]);
        this.cache = cache;
        this.highLabelId = highLabelId;
        this.highRelationshipTypeId = highRelationshipTypeId;
        this.countsUpdater = countsUpdater;
        this.cacheFactory = cacheFactory;
        this.progressMonitor = progressMonitor;
    }

    @Override
    protected void process(RelationshipRecord[] batch, BatchSender sender) {
        RelationshipCountsProcessor processor = this.processor();
        for (int i = 0; i < batch.length; ++i) {
            RelationshipRecord relationship = batch[i];
            processor.process(relationship.getFirstNode(), relationship.getType(), relationship.getSecondNode());
        }
        this.progressMonitor.progress(batch.length);
    }

    private RelationshipCountsProcessor processor() {
        RelationshipCountsProcessor processor = this.processors.get(Thread.currentThread());
        if (processor == null) {
            processor = new RelationshipCountsProcessor(this.cache, this.highLabelId, this.highRelationshipTypeId, this.countsUpdater, this.cacheFactory);
            this.processors.put(Thread.currentThread(), processor);
        }
        return processor;
    }

    @Override
    protected void done() {
        super.done();
        RelationshipCountsProcessor all = null;
        for (RelationshipCountsProcessor processor : this.processors.values()) {
            if (all == null) {
                all = processor;
                continue;
            }
            all.addCountsFrom(processor);
        }
        if (all != null) {
            all.done();
        }
    }
}

