/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.storemigration.legacylogs;

import java.io.FilenameFilter;

public class LegacyLogFilenames {
    private static final String legacyLogFilesPrefix = "nioneo_logical.log.v";
    private static final String versionedLegacyLogFilesPattern = "nioneo_logical\\.log\\.v\\d+";
    private static final String[] allLegacyLogFilesPatterns = new String[]{"active_tx_log", "tm_tx_log\\..*", "nioneo_logical\\.log\\..*"};
    public static final FilenameFilter versionedLegacyLogFilesFilter = (dir, name) -> name.matches(versionedLegacyLogFilesPattern);
    static final FilenameFilter allLegacyLogFilesFilter = (dir, name) -> {
        for (String pattern : allLegacyLogFilesPatterns) {
            if (!name.matches(pattern)) continue;
            return true;
        }
        return false;
    };

    private LegacyLogFilenames() {
    }

    static long getLegacyLogVersion(String filename) {
        int index = filename.lastIndexOf(".v");
        if (index == -1) {
            throw new RuntimeException("Invalid log file '" + filename + "'");
        }
        return Long.parseLong(filename.substring(index + ".v".length()));
    }

    static String getLegacyLogFilename(int version) {
        return legacyLogFilesPrefix + version;
    }
}

