/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.io.IOException;
import org.neo4j.collection.primitive.PrimitiveLongSet;
import org.neo4j.index.internal.gbptree.Writer;
import org.neo4j.kernel.api.exceptions.index.IndexEntryConflictException;
import org.neo4j.kernel.api.index.IndexEntryUpdate;
import org.neo4j.kernel.api.index.IndexUpdater;
import org.neo4j.kernel.impl.index.schema.ConflictDetectingValueMerger;
import org.neo4j.kernel.impl.index.schema.SchemaNumberKey;
import org.neo4j.kernel.impl.index.schema.SchemaNumberValue;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.ValueTuple;

class NativeSchemaNumberIndexUpdater<KEY extends SchemaNumberKey, VALUE extends SchemaNumberValue>
implements IndexUpdater {
    private final KEY treeKey;
    private final VALUE treeValue;
    private final ConflictDetectingValueMerger<KEY, VALUE> conflictDetectingValueMerger;
    private Writer<KEY, VALUE> writer;
    private boolean closed = true;
    private boolean manageClosingOfWriter;

    NativeSchemaNumberIndexUpdater(KEY treeKey, VALUE treeValue) {
        this.treeKey = treeKey;
        this.treeValue = treeValue;
        this.conflictDetectingValueMerger = new ConflictDetectingValueMerger();
    }

    NativeSchemaNumberIndexUpdater<KEY, VALUE> initialize(Writer<KEY, VALUE> writer, boolean manageClosingOfWriter) {
        if (!this.closed) {
            throw new IllegalStateException("Updater still open");
        }
        this.manageClosingOfWriter = manageClosingOfWriter;
        this.writer = writer;
        this.closed = false;
        return this;
    }

    @Override
    public void process(IndexEntryUpdate update) throws IOException, IndexEntryConflictException {
        this.assertOpen();
        switch (update.updateMode()) {
            case ADDED: {
                NativeSchemaNumberIndexUpdater.processAdd(this.treeKey, this.treeValue, update, this.writer, this.conflictDetectingValueMerger);
                break;
            }
            case CHANGED: {
                NativeSchemaNumberIndexUpdater.processChange(this.treeKey, this.treeValue, update, this.writer, this.conflictDetectingValueMerger);
                break;
            }
            case REMOVED: {
                NativeSchemaNumberIndexUpdater.processRemove(this.treeKey, update, this.writer);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    @Override
    public void close() throws IOException, IndexEntryConflictException {
        if (this.manageClosingOfWriter) {
            this.writer.close();
        }
        this.closed = true;
    }

    @Override
    public void remove(PrimitiveLongSet nodeIds) throws IOException {
        this.assertOpen();
    }

    private void assertOpen() {
        if (this.closed) {
            throw new IllegalStateException("Updater has been closed");
        }
    }

    private static <KEY extends SchemaNumberKey, VALUE extends SchemaNumberValue> void processRemove(KEY treeKey, IndexEntryUpdate<?> update, Writer<KEY, VALUE> writer) throws IOException {
        treeKey.from(update.getEntityId(), update.values());
        writer.remove(treeKey);
    }

    private static <KEY extends SchemaNumberKey, VALUE extends SchemaNumberValue> void processChange(KEY treeKey, VALUE treeValue, IndexEntryUpdate<?> update, Writer<KEY, VALUE> writer, ConflictDetectingValueMerger<KEY, VALUE> conflictDetectingValueMerger) throws IOException, IndexEntryConflictException {
        treeKey.from(update.getEntityId(), update.beforeValues());
        writer.remove(treeKey);
        treeKey.from(update.getEntityId(), update.values());
        treeValue.from(update.values());
        writer.merge(treeKey, treeValue, conflictDetectingValueMerger);
        NativeSchemaNumberIndexUpdater.assertNoConflict(update, conflictDetectingValueMerger);
    }

    static <KEY extends SchemaNumberKey, VALUE extends SchemaNumberValue> void processAdd(KEY treeKey, VALUE treeValue, IndexEntryUpdate<?> update, Writer<KEY, VALUE> writer, ConflictDetectingValueMerger<KEY, VALUE> conflictDetectingValueMerger) throws IOException, IndexEntryConflictException {
        treeKey.from(update.getEntityId(), update.values());
        treeValue.from(update.values());
        writer.merge(treeKey, treeValue, conflictDetectingValueMerger);
        NativeSchemaNumberIndexUpdater.assertNoConflict(update, conflictDetectingValueMerger);
    }

    private static <KEY extends SchemaNumberKey, VALUE extends SchemaNumberValue> void assertNoConflict(IndexEntryUpdate<?> update, ConflictDetectingValueMerger<KEY, VALUE> conflictDetectingValueMerger) throws IndexEntryConflictException {
        if (conflictDetectingValueMerger.wasConflict()) {
            long existingNodeId = conflictDetectingValueMerger.existingNodeId();
            long addedNodeId = conflictDetectingValueMerger.addedNodeId();
            throw new IndexEntryConflictException(existingNodeId, addedNodeId, ValueTuple.of((Value[])update.values()));
        }
    }
}

