/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import org.neo4j.index.internal.gbptree.Layout;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.api.index.IndexEntryUpdate;
import org.neo4j.kernel.impl.api.index.sampling.DefaultNonUniqueIndexSampler;
import org.neo4j.kernel.impl.api.index.sampling.IndexSamplingConfig;
import org.neo4j.kernel.impl.api.index.sampling.NonUniqueIndexSampler;
import org.neo4j.kernel.impl.index.schema.FullScanNonUniqueIndexSampler;
import org.neo4j.kernel.impl.index.schema.NativeSchemaNumberIndexPopulator;
import org.neo4j.kernel.impl.index.schema.SamplingUtil;
import org.neo4j.kernel.impl.index.schema.SchemaNumberKey;
import org.neo4j.kernel.impl.index.schema.SchemaNumberValue;
import org.neo4j.storageengine.api.schema.IndexSample;

class NativeNonUniqueSchemaNumberIndexPopulator<KEY extends SchemaNumberKey, VALUE extends SchemaNumberValue>
extends NativeSchemaNumberIndexPopulator<KEY, VALUE> {
    private final IndexSamplingConfig samplingConfig;
    private boolean updateSampling;
    private NonUniqueIndexSampler sampler;

    NativeNonUniqueSchemaNumberIndexPopulator(PageCache pageCache, File storeFile, Layout<KEY, VALUE> layout, IndexSamplingConfig samplingConfig) {
        super(pageCache, storeFile, layout);
        this.samplingConfig = samplingConfig;
    }

    @Override
    public void includeSample(IndexEntryUpdate update) {
        if (this.updateSampling) {
            this.checkSampler();
            this.sampler.include(SamplingUtil.encodedStringValuesForSampling(update.values()));
        }
    }

    @Override
    public void configureSampling(boolean onlineSampling) {
        this.updateSampling = onlineSampling;
        this.sampler = onlineSampling ? new DefaultNonUniqueIndexSampler(this.samplingConfig.sampleSizeLimit()) : new FullScanNonUniqueIndexSampler(this.tree, this.layout, this.samplingConfig);
    }

    @Override
    public IndexSample sampleResult() {
        this.checkSampler();
        try {
            this.closeWriter();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        try {
            IndexSample indexSample = this.sampler.result();
            return indexSample;
        }
        finally {
            try {
                this.instantiateWriter();
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
    }

    private void checkSampler() {
        if (this.sampler == null) {
            throw new IllegalStateException("Please configure populator sampler before using it.");
        }
    }
}

