/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.scan;

import java.util.function.Supplier;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.index.internal.gbptree.RecoveryCleanupWorkCollector;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.api.labelscan.LoggingMonitor;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.extension.KernelExtensionFactory;
import org.neo4j.kernel.impl.api.index.IndexStoreView;
import org.neo4j.kernel.impl.api.scan.FullLabelStream;
import org.neo4j.kernel.impl.api.scan.LabelScanStoreProvider;
import org.neo4j.kernel.impl.factory.OperationalMode;
import org.neo4j.kernel.impl.index.labelscan.NativeLabelScanStore;
import org.neo4j.kernel.impl.logging.LogService;
import org.neo4j.kernel.impl.spi.KernelContext;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.kernel.monitoring.Monitors;
import org.neo4j.logging.Log;

public class NativeLabelScanStoreExtension
extends KernelExtensionFactory<Dependencies> {
    public NativeLabelScanStoreExtension() {
        super(NativeLabelScanStore.NATIVE_LABEL_INDEX_TAG);
    }

    @Override
    public Lifecycle newInstance(KernelContext context, Dependencies dependencies) throws Throwable {
        Log log = dependencies.getLogService().getInternalLog(NativeLabelScanStore.class);
        Monitors monitors = dependencies.monitors();
        monitors.addMonitorListener(new LoggingMonitor(log), NativeLabelScanStore.NATIVE_LABEL_INDEX_TAG);
        RecoveryCleanupWorkCollector recoveryCleanupWorkCollector = dependencies.recoveryCleanupExecutor();
        Boolean readOnly = this.isReadOnly(context, dependencies);
        NativeLabelScanStore labelScanStore = new NativeLabelScanStore(dependencies.pageCache(), context.storeDir(), new FullLabelStream(dependencies.indexStoreView()), readOnly, monitors, recoveryCleanupWorkCollector);
        return new LabelScanStoreProvider(NativeLabelScanStore.NATIVE_LABEL_INDEX_TAG, labelScanStore);
    }

    private Boolean isReadOnly(KernelContext context, Dependencies dependencies) {
        OperationalMode operationalMode = context.databaseInfo().operationalMode;
        return dependencies.getConfig().get(GraphDatabaseSettings.read_only) != false && operationalMode == OperationalMode.single;
    }

    public static interface Dependencies {
        public Config getConfig();

        public PageCache pageCache();

        public Supplier<IndexStoreView> indexStoreView();

        public LogService getLogService();

        public RecoveryCleanupWorkCollector recoveryCleanupExecutor();

        public Monitors monitors();
    }
}

