/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.scan;

import java.io.File;
import java.io.IOException;
import org.neo4j.kernel.api.labelscan.LabelScanStore;
import org.neo4j.kernel.api.labelscan.LabelScanWriter;
import org.neo4j.kernel.impl.api.scan.FullStoreChangeStream;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;

public class LabelScanStoreProvider
extends LifecycleAdapter {
    private final String name;
    private final LabelScanStore labelScanStore;

    public LabelScanStoreProvider(String name, LabelScanStore labelScanStore) {
        this.name = name;
        this.labelScanStore = labelScanStore;
    }

    public String getName() {
        return this.name;
    }

    public static File getLuceneStoreDirectory(File storeRootDir) {
        return new File(new File(new File(storeRootDir, "schema"), "label"), "lucene");
    }

    public LabelScanStore getLabelScanStore() {
        return this.labelScanStore;
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName() + "[" + this.labelScanStore + "]";
    }

    public static long rebuild(LabelScanStore store, FullStoreChangeStream fullStoreStream) throws IOException {
        try (LabelScanWriter writer = store.newWriter();){
            long l = fullStoreStream.applyTo(writer);
            return l;
        }
    }

    public boolean isReadOnly() {
        return this.labelScanStore.isReadOnly();
    }

    public void drop() throws IOException {
        this.labelScanStore.drop();
    }

    public boolean hasStore() throws IOException {
        return this.labelScanStore.hasStore();
    }
}

