/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.guard;

import java.time.Clock;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.guard.Guard;
import org.neo4j.kernel.guard.GuardTimeoutException;
import org.neo4j.kernel.impl.api.KernelStatement;
import org.neo4j.kernel.impl.api.KernelTransactionImplementation;
import org.neo4j.logging.Log;

public class TimeoutGuard
implements Guard {
    private final Log log;
    private final Clock clock;

    public TimeoutGuard(Clock clock, Log log) {
        this.log = log;
        this.clock = clock;
    }

    @Override
    public void check(KernelStatement statement) {
        this.check(statement.getTransaction());
    }

    @Override
    public void check(KernelTransactionImplementation transaction) {
        if (transaction.timeout() > 0L) {
            this.check(transaction, "Transaction timeout.");
        }
    }

    private void check(KernelTransactionImplementation transaction, String timeoutDescription) {
        long now = this.clock.millis();
        long maxCompletionTime = TimeoutGuard.getMaxTransactionCompletionTime(transaction);
        if (maxCompletionTime < now) {
            long overtime = now - maxCompletionTime;
            String message = timeoutDescription + " (Overtime: " + overtime + " ms).";
            this.log.warn(message);
            transaction.markForTermination((Status)Status.Transaction.TransactionTimedOut);
            throw new GuardTimeoutException(message, overtime);
        }
    }

    private static long getMaxTransactionCompletionTime(KernelTransactionImplementation transaction) {
        return transaction.startTime() + transaction.timeout();
    }
}

