/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.configuration;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Map;
import javax.annotation.Nonnull;
import org.neo4j.configuration.LoadableConfig;
import org.neo4j.helpers.collection.Pair;
import org.neo4j.kernel.configuration.ConfigurationMigrator;
import org.neo4j.kernel.configuration.Migrator;
import org.neo4j.logging.Log;

public class AnnotationBasedConfigurationMigrator
implements ConfigurationMigrator {
    private ArrayList<ConfigurationMigrator> migrators = new ArrayList();

    AnnotationBasedConfigurationMigrator(@Nonnull Iterable<LoadableConfig> settingsClasses) {
        for (LoadableConfig loadableConfig : settingsClasses) {
            for (Pair<Field, ConfigurationMigrator> field : AnnotationBasedConfigurationMigrator.findStatic(loadableConfig.getClass(), ConfigurationMigrator.class, Migrator.class)) {
                this.migrators.add((ConfigurationMigrator)field.other());
            }
        }
    }

    @Override
    @Nonnull
    public Map<String, String> apply(@Nonnull Map<String, String> rawConfiguration, @Nonnull Log log) {
        for (ConfigurationMigrator migrator : this.migrators) {
            rawConfiguration = migrator.apply(rawConfiguration, log);
        }
        return rawConfiguration;
    }

    private static <T> Iterable<Pair<Field, T>> findStatic(Class<?> clazz, Class<T> type, Class annotation) {
        ArrayList<Pair<Field, T>> found = new ArrayList<Pair<Field, T>>();
        for (Field field : clazz.getDeclaredFields()) {
            try {
                field.setAccessible(true);
                Object fieldValue = field.get(null);
                if (!type.isInstance(fieldValue) || annotation != null && field.getAnnotation(annotation) == null) continue;
                found.add(Pair.of((Object)field, (Object)fieldValue));
            }
            catch (IllegalAccessException | NullPointerException exception) {
                // empty catch block
            }
        }
        return found;
    }
}

