/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.batchinsert.internal;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Map;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.schema.ConstraintCreator;
import org.neo4j.graphdb.schema.IndexCreator;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.impl.index.IndexConfigStore;
import org.neo4j.unsafe.batchinsert.BatchInserter;
import org.neo4j.unsafe.batchinsert.BatchRelationship;
import org.neo4j.unsafe.batchinsert.internal.IndexConfigStoreProvider;
import org.neo4j.values.Value;

public class FileSystemClosingBatchInserter
implements BatchInserter,
IndexConfigStoreProvider {
    private final BatchInserter delegate;
    private final IndexConfigStoreProvider configStoreProvider;
    private final FileSystemAbstraction fileSystem;

    public FileSystemClosingBatchInserter(BatchInserter delegate, IndexConfigStoreProvider configStoreProvider, FileSystemAbstraction fileSystem) {
        this.delegate = delegate;
        this.configStoreProvider = configStoreProvider;
        this.fileSystem = fileSystem;
    }

    @Override
    public long createNode(Map<String, Object> properties, Label ... labels) {
        return this.delegate.createNode(properties, labels);
    }

    @Override
    public void createNode(long id, Map<String, Object> properties, Label ... labels) {
        this.delegate.createNode(id, properties, labels);
    }

    @Override
    public boolean nodeExists(long nodeId) {
        return this.delegate.nodeExists(nodeId);
    }

    @Override
    public void setNodeProperties(long node, Map<String, Object> properties) {
        this.delegate.setNodeProperties(node, properties);
    }

    @Override
    public boolean nodeHasProperty(long node, String propertyName) {
        return this.delegate.nodeHasProperty(node, propertyName);
    }

    @Override
    public void setNodeLabels(long node, Label ... labels) {
        this.delegate.setNodeLabels(node, labels);
    }

    @Override
    public Iterable<Label> getNodeLabels(long node) {
        return this.delegate.getNodeLabels(node);
    }

    @Override
    public boolean nodeHasLabel(long node, Label label) {
        return this.delegate.nodeHasLabel(node, label);
    }

    @Override
    public boolean relationshipHasProperty(long relationship, String propertyName) {
        return this.delegate.relationshipHasProperty(relationship, propertyName);
    }

    @Override
    public void setNodeProperty(long node, String propertyName, Object propertyValue) {
        this.delegate.setNodeProperty(node, propertyName, propertyValue);
    }

    @Override
    public void setRelationshipProperty(long relationship, String propertyName, Object propertyValue) {
        this.delegate.setRelationshipProperty(relationship, propertyName, propertyValue);
    }

    @Override
    public Map<String, Value> getNodeProperties(long nodeId) {
        return this.delegate.getNodeProperties(nodeId);
    }

    @Override
    public Iterable<Long> getRelationshipIds(long nodeId) {
        return this.delegate.getRelationshipIds(nodeId);
    }

    @Override
    public Iterable<BatchRelationship> getRelationships(long nodeId) {
        return this.delegate.getRelationships(nodeId);
    }

    @Override
    public long createRelationship(long node1, long node2, RelationshipType type, Map<String, Object> properties) {
        return this.delegate.createRelationship(node1, node2, type, properties);
    }

    @Override
    public BatchRelationship getRelationshipById(long relId) {
        return this.delegate.getRelationshipById(relId);
    }

    @Override
    public void setRelationshipProperties(long rel, Map<String, Object> properties) {
        this.delegate.setRelationshipProperties(rel, properties);
    }

    @Override
    public Map<String, Value> getRelationshipProperties(long relId) {
        return this.delegate.getRelationshipProperties(relId);
    }

    @Override
    public void removeNodeProperty(long node, String property) {
        this.delegate.removeNodeProperty(node, property);
    }

    @Override
    public void removeRelationshipProperty(long relationship, String property) {
        this.delegate.removeRelationshipProperty(relationship, property);
    }

    @Override
    public IndexCreator createDeferredSchemaIndex(Label label) {
        return this.delegate.createDeferredSchemaIndex(label);
    }

    @Override
    public ConstraintCreator createDeferredConstraint(Label label) {
        return this.delegate.createDeferredConstraint(label);
    }

    @Override
    public void shutdown() {
        this.delegate.shutdown();
        this.closeFileSystem();
    }

    @Override
    public String getStoreDir() {
        return this.delegate.getStoreDir();
    }

    public FileSystemAbstraction getFileSystem() {
        return this.fileSystem;
    }

    private void closeFileSystem() {
        try {
            this.fileSystem.close();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public IndexConfigStore getIndexStore() {
        return this.configStoreProvider.getIndexStore();
    }
}

