/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.util;

import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import org.neo4j.io.fs.DefaultFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.impl.api.IndexValueValidator;
import org.neo4j.kernel.impl.api.LegacyIndexValueValidator;
import org.neo4j.kernel.impl.storemigration.StoreFileType;
import org.neo4j.kernel.impl.util.Validator;

public class Validators {
    public static final IndexValueValidator INDEX_VALUE_VALIDATOR = IndexValueValidator.INSTANCE;
    public static final LegacyIndexValueValidator LEGACY_INDEX_VALUE_VALIDATOR = LegacyIndexValueValidator.INSTANCE;
    public static final Validator<File> REGEX_FILE_EXISTS = file -> {
        if (Validators.matchingFiles(file).isEmpty()) {
            throw new IllegalArgumentException("File '" + file + "' doesn't exist");
        }
    };
    public static final Validator<File> DIRECTORY_IS_WRITABLE = value -> {
        if (value.mkdirs()) {
            return;
        }
        File test = new File((File)value, "_______test___");
        try {
            test.createNewFile();
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Directoy '" + value + "' not writable: " + e.getMessage());
        }
        finally {
            test.delete();
        }
    };
    public static final Validator<File> CONTAINS_NO_EXISTING_DATABASE = value -> {
        try (DefaultFileSystemAbstraction fileSystem = new DefaultFileSystemAbstraction();){
            if (Validators.isExistingDatabase((FileSystemAbstraction)fileSystem, value)) {
                throw new IllegalArgumentException("Directory '" + value + "' already contains a database");
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    };
    public static final Validator<File> CONTAINS_EXISTING_DATABASE = value -> {
        try (DefaultFileSystemAbstraction fileSystem = new DefaultFileSystemAbstraction();){
            if (!Validators.isExistingDatabase((FileSystemAbstraction)fileSystem, value)) {
                throw new IllegalArgumentException("Directory '" + value + "' does not contain a database");
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    };

    private Validators() {
    }

    static List<File> matchingFiles(File fileWithRegexInName) {
        File parent = fileWithRegexInName.getAbsoluteFile().getParentFile();
        if (parent == null || !parent.exists()) {
            throw new IllegalArgumentException("Directory of " + fileWithRegexInName + " doesn't exist");
        }
        Pattern pattern = Pattern.compile(fileWithRegexInName.getName());
        ArrayList<File> files = new ArrayList<File>();
        for (File file : parent.listFiles()) {
            if (!pattern.matcher(file.getName()).matches()) continue;
            files.add(file);
        }
        return files;
    }

    private static boolean isExistingDatabase(FileSystemAbstraction fileSystem, File value) {
        return fileSystem.fileExists(new File(value, StoreFileType.STORE.augment("neostore")));
    }

    public static Validator<String> inList(String[] validStrings) {
        return value -> {
            if (Arrays.stream(validStrings).noneMatch(s -> s.equals(value))) {
                throw new IllegalArgumentException("'" + value + "' found but must be one of: " + Arrays.toString(validStrings) + ".");
            }
        };
    }

    public static <T> Validator<T[]> atLeast(String key, int length) {
        return value -> {
            if (((Object[])value).length < length) {
                throw new IllegalArgumentException("Expected '" + key + "' to have at least " + length + " valid item" + (length == 1 ? "" : "s") + ", but had " + ((Object[])value).length + " " + Arrays.toString(value));
            }
        };
    }

    public static <T> Validator<T> emptyValidator() {
        return value -> {};
    }
}

