/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.storemigration.legacystore.v21.propertydeduplication;

import java.io.IOException;
import java.util.Iterator;
import org.neo4j.collection.primitive.PrimitiveLongVisitor;
import org.neo4j.kernel.impl.store.PropertyStore;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.store.record.PropertyBlock;
import org.neo4j.kernel.impl.store.record.PropertyRecord;
import org.neo4j.kernel.impl.store.record.RecordLoad;
import org.neo4j.kernel.impl.storemigration.legacystore.v21.propertydeduplication.DuplicatePropertyRemover;
import org.neo4j.kernel.impl.storemigration.legacystore.v21.propertydeduplication.IndexLookup;
import org.neo4j.values.Value;

class IndexConsultedPropertyBlockSweeper
implements PrimitiveLongVisitor<IOException> {
    private final int propertyKeyId;
    private final IndexLookup.Index index;
    private final NodeRecord nodeRecord;
    boolean foundExact;
    private final PropertyStore propertyStore;
    private final PropertyRecord propertyRecord;
    private final DuplicatePropertyRemover propertyRemover;

    IndexConsultedPropertyBlockSweeper(int propertyKeyId, IndexLookup.Index index, NodeRecord nodeRecord, PropertyStore propertyStore, DuplicatePropertyRemover propertyRemover) {
        this.propertyKeyId = propertyKeyId;
        this.index = index;
        this.nodeRecord = nodeRecord;
        this.propertyStore = propertyStore;
        this.propertyRemover = propertyRemover;
        this.foundExact = false;
        this.propertyRecord = propertyStore.newRecord();
    }

    public boolean visited(long propRecordId) throws IOException {
        this.propertyStore.getRecord(propRecordId, this.propertyRecord, RecordLoad.NORMAL);
        boolean changed = false;
        Iterator<PropertyBlock> it = this.propertyRecord.iterator();
        while (it.hasNext()) {
            PropertyBlock block = it.next();
            if (block.getKeyIndexId() != this.propertyKeyId) continue;
            Value propertyValue = this.propertyStore.getValue(block);
            if (!this.foundExact && this.index.contains(this.nodeRecord.getId(), propertyValue)) {
                this.foundExact = true;
                continue;
            }
            it.remove();
            changed = true;
        }
        if (changed) {
            if (this.propertyRecord.numberOfProperties() == 0) {
                this.propertyRemover.fixUpPropertyLinksAroundUnusedRecord(this.nodeRecord, this.propertyRecord);
            }
            this.propertyStore.updateRecord(this.propertyRecord);
        }
        return false;
    }
}

