/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import org.neo4j.kernel.impl.index.schema.SchemaNumberKey;
import org.neo4j.kernel.impl.index.schema.SchemaNumberValueConversion;
import org.neo4j.values.Value;

class UniqueSchemaNumberKey
implements SchemaNumberKey {
    static final int SIZE = 64;
    double value;
    boolean isHighest;

    UniqueSchemaNumberKey() {
    }

    @Override
    public void from(long entityId, Value[] values) {
        this.value = SchemaNumberValueConversion.assertValidSingleNumber(values).doubleValue();
        this.isHighest = false;
    }

    @Override
    public String propertiesAsString() {
        throw new UnsupportedOperationException("Implement me");
    }

    @Override
    public void initAsLowest() {
        this.value = Double.NEGATIVE_INFINITY;
        this.isHighest = false;
    }

    @Override
    public void initAsHighest() {
        this.value = Double.POSITIVE_INFINITY;
        this.isHighest = true;
    }

    public String toString() {
        return "compareValue=" + this.value;
    }
}

