/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import org.neo4j.values.Value;
import org.neo4j.values.Values;

class SchemaNumberValueConversion {
    SchemaNumberValueConversion() {
    }

    static Number assertValidSingleNumber(Value[] values) {
        if (values.length > 1) {
            throw new IllegalArgumentException("Tried to create composite key with non-composite schema key layout");
        }
        if (values.length < 1) {
            throw new IllegalArgumentException("Tried to create key without value");
        }
        if (!Values.isNumberValue((Object)values[0])) {
            throw new IllegalArgumentException("Key layout does only support numbers, tried to create key from " + values[0]);
        }
        return (Number)values[0].asObject();
    }

    static Number toValue(byte type, long rawValueBits) {
        switch (type) {
            case 0: {
                return rawValueBits;
            }
            case 1: {
                return Float.valueOf(Float.intBitsToFloat((int)rawValueBits));
            }
            case 2: {
                return Double.longBitsToDouble(rawValueBits);
            }
        }
        throw new IllegalArgumentException("Unexpected type " + type);
    }
}

