/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import org.neo4j.kernel.impl.index.schema.SchemaNumberKey;
import org.neo4j.kernel.impl.index.schema.SchemaNumberValueConversion;
import org.neo4j.values.Value;

class NonUniqueSchemaNumberKey
implements SchemaNumberKey {
    static final int SIZE = 128;
    double value;
    long entityId;

    NonUniqueSchemaNumberKey() {
    }

    @Override
    public void from(long entityId, Value[] values) {
        this.value = SchemaNumberValueConversion.assertValidSingleNumber(values).doubleValue();
        this.entityId = entityId;
    }

    @Override
    public String propertiesAsString() {
        return String.valueOf(this.value);
    }

    @Override
    public void initAsLowest() {
        this.value = Double.NEGATIVE_INFINITY;
        this.entityId = Long.MIN_VALUE;
    }

    @Override
    public void initAsHighest() {
        this.value = Double.POSITIVE_INFINITY;
        this.entityId = Long.MAX_VALUE;
    }

    public String toString() {
        return "compareValue=" + this.value + ",entityId=" + this.entityId;
    }
}

