/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.state;

import java.util.Iterator;
import org.apache.commons.lang3.ArrayUtils;
import org.neo4j.collection.primitive.Primitive;
import org.neo4j.collection.primitive.PrimitiveIntSet;
import org.neo4j.cursor.Cursor;
import org.neo4j.kernel.api.exceptions.EntityNotFoundException;
import org.neo4j.kernel.api.schema.index.IndexDescriptor;
import org.neo4j.kernel.impl.api.KernelStatement;
import org.neo4j.kernel.impl.api.operations.EntityReadOperations;
import org.neo4j.kernel.impl.api.schema.NodeSchemaMatcher;
import org.neo4j.kernel.impl.util.Validators;
import org.neo4j.storageengine.api.NodeItem;
import org.neo4j.storageengine.api.PropertyItem;
import org.neo4j.storageengine.api.StoreReadLayer;
import org.neo4j.values.Value;
import org.neo4j.values.ValueTuple;
import org.neo4j.values.Values;

public class IndexTxStateUpdater {
    private final StoreReadLayer storeReadLayer;
    private final EntityReadOperations readOps;
    private final NodeSchemaMatcher nodeIndexMatcher;

    public IndexTxStateUpdater(StoreReadLayer storeReadLayer, EntityReadOperations readOps) {
        this.storeReadLayer = storeReadLayer;
        this.readOps = readOps;
        this.nodeIndexMatcher = new NodeSchemaMatcher(readOps);
    }

    public void onLabelChange(KernelStatement state, int labelId, NodeItem node, LabelChangeType changeType) throws EntityNotFoundException {
        assert (this.noSchemaChangedInTx(state));
        PrimitiveIntSet nodePropertyIds = Primitive.intSet();
        nodePropertyIds.addAll(this.readOps.nodeGetPropertyKeys(state, node).iterator());
        Iterator<IndexDescriptor> indexes = this.storeReadLayer.indexesGetForLabel(labelId);
        while (indexes.hasNext()) {
            IndexDescriptor index = indexes.next();
            int[] indexPropertyIds = index.schema().getPropertyIds();
            if (!IndexTxStateUpdater.nodeHasIndexProperties(nodePropertyIds, indexPropertyIds)) continue;
            ValueTuple values = this.getValueTuple(state, node, indexPropertyIds);
            if (changeType == LabelChangeType.ADDED_LABEL) {
                for (int i = 0; i < values.size(); ++i) {
                    Validators.INDEX_VALUE_VALIDATOR.validate(values.valueAt(i));
                }
                state.txState().indexDoUpdateEntry(index.schema(), node.id(), null, values);
                continue;
            }
            state.txState().indexDoUpdateEntry(index.schema(), node.id(), values, null);
        }
    }

    private boolean noSchemaChangedInTx(KernelStatement state) {
        return !state.txState().hasChanges() || state.txState().hasDataChanges();
    }

    public void onPropertyAdd(KernelStatement state, NodeItem node, int propertyKeyId, Value value) throws EntityNotFoundException {
        assert (this.noSchemaChangedInTx(state));
        Iterator<IndexDescriptor> indexes = this.storeReadLayer.indexesGetRelatedToProperty(propertyKeyId);
        this.nodeIndexMatcher.onMatchingSchema(state, indexes, node, propertyKeyId, (index, propertyKeyIds) -> {
            Validators.INDEX_VALUE_VALIDATOR.validate(value);
            ValueTuple values = this.getValueTuple(state, node, propertyKeyId, value, index.schema().getPropertyIds());
            state.txState().indexDoUpdateEntry(index.schema(), node.id(), null, values);
        });
    }

    public void onPropertyRemove(KernelStatement state, NodeItem node, int propertyKeyId, Value value) throws EntityNotFoundException {
        assert (this.noSchemaChangedInTx(state));
        Iterator<IndexDescriptor> indexes = this.storeReadLayer.indexesGetRelatedToProperty(propertyKeyId);
        this.nodeIndexMatcher.onMatchingSchema(state, indexes, node, propertyKeyId, (index, propertyKeyIds) -> {
            ValueTuple values = this.getValueTuple(state, node, propertyKeyId, value, index.schema().getPropertyIds());
            state.txState().indexDoUpdateEntry(index.schema(), node.id(), values, null);
        });
    }

    public void onPropertyChange(KernelStatement state, NodeItem node, int propertyKeyId, Value beforeValue, Value afterValue) throws EntityNotFoundException {
        assert (this.noSchemaChangedInTx(state));
        Iterator<IndexDescriptor> indexes = this.storeReadLayer.indexesGetRelatedToProperty(propertyKeyId);
        this.nodeIndexMatcher.onMatchingSchema(state, indexes, node, propertyKeyId, (index, propertyKeyIds) -> {
            Validators.INDEX_VALUE_VALIDATOR.validate(afterValue);
            int[] indexPropertyIds = index.schema().getPropertyIds();
            Value[] valuesBefore = new Value[indexPropertyIds.length];
            Value[] valuesAfter = new Value[indexPropertyIds.length];
            for (int i = 0; i < indexPropertyIds.length; ++i) {
                Value value;
                int indexPropertyId = indexPropertyIds[i];
                if (indexPropertyId == propertyKeyId) {
                    valuesBefore[i] = beforeValue;
                    valuesAfter[i] = afterValue;
                    continue;
                }
                valuesBefore[i] = value = this.readOps.nodeGetProperty(state, node, indexPropertyId);
                valuesAfter[i] = value;
            }
            state.txState().indexDoUpdateEntry(index.schema(), node.id(), ValueTuple.of((Value[])valuesBefore), ValueTuple.of((Value[])valuesAfter));
        });
    }

    private ValueTuple getValueTuple(KernelStatement state, NodeItem node, int[] indexPropertyIds) {
        return this.getValueTuple(state, node, -1, Values.NO_VALUE, indexPropertyIds);
    }

    private ValueTuple getValueTuple(KernelStatement state, NodeItem node, int changedPropertyKeyId, Value changedValue, int[] indexPropertyIds) {
        int k;
        Value[] values = new Value[indexPropertyIds.length];
        Cursor<PropertyItem> propertyCursor = this.readOps.nodeGetProperties(state, node);
        while (propertyCursor.next()) {
            PropertyItem property = (PropertyItem)propertyCursor.get();
            int k2 = ArrayUtils.indexOf((int[])indexPropertyIds, (int)property.propertyKeyId());
            if (k2 < 0) continue;
            values[k2] = indexPropertyIds[k2] == changedPropertyKeyId ? changedValue : property.value();
        }
        if (changedPropertyKeyId != -1 && (k = ArrayUtils.indexOf((int[])indexPropertyIds, (int)changedPropertyKeyId)) >= 0) {
            values[k] = changedValue;
        }
        return ValueTuple.of((Value[])values);
    }

    private static boolean nodeHasIndexProperties(PrimitiveIntSet nodeProperties, int[] indexPropertyIds) {
        for (int indexPropertyId : indexPropertyIds) {
            if (nodeProperties.contains(indexPropertyId)) continue;
            return false;
        }
        return true;
    }

    public static enum LabelChangeType {
        ADDED_LABEL,
        REMOVED_LABEL;

    }
}

