/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.internal;

import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import org.neo4j.helpers.Format;
import org.neo4j.kernel.impl.factory.DatabaseInfo;
import org.neo4j.kernel.impl.store.StoreId;
import org.neo4j.kernel.impl.store.StoreType;
import org.neo4j.kernel.info.DiagnosticsPhase;
import org.neo4j.kernel.info.DiagnosticsProvider;
import org.neo4j.kernel.internal.Version;
import org.neo4j.logging.Logger;

public abstract class KernelDiagnostics
implements DiagnosticsProvider {
    @Override
    public String getDiagnosticsIdentifier() {
        return this.getClass().getDeclaringClass().getSimpleName() + ":" + this.getClass().getSimpleName();
    }

    @Override
    public void acceptDiagnosticsVisitor(Object visitor) {
    }

    @Override
    public void dump(DiagnosticsPhase phase, Logger log) {
        if (phase.isInitialization() || phase.isExplicitlyRequested()) {
            this.dump(log);
        }
    }

    abstract void dump(Logger var1);

    public static class StoreFiles
    extends KernelDiagnostics {
        private final File storeDir;
        private static String FORMAT_DATE_ISO = "yyyy-MM-dd'T'HH:mm:ssZ";
        private final SimpleDateFormat dateFormat;

        public StoreFiles(File storeDir) {
            this.storeDir = storeDir;
            TimeZone tz = TimeZone.getDefault();
            this.dateFormat = new SimpleDateFormat(FORMAT_DATE_ISO);
            this.dateFormat.setTimeZone(tz);
        }

        @Override
        void dump(Logger logger) {
            logger.log(this.getDiskSpace(this.storeDir));
            logger.log("Storage files: (filename : modification date - size)");
            MappedFileCounter mappedCounter = new MappedFileCounter();
            long totalSize = this.logStoreFiles(logger, "  ", this.storeDir, mappedCounter);
            logger.log("Storage summary: ");
            logger.log("  Total size of store: " + Format.bytes(totalSize));
            logger.log("  Total size of mapped files: " + Format.bytes(mappedCounter.getSize()));
        }

        private long logStoreFiles(Logger logger, String prefix, File dir, MappedFileCounter mappedCounter) {
            if (!dir.isDirectory()) {
                return 0L;
            }
            File[] files = dir.listFiles();
            if (files == null) {
                logger.log(prefix + "<INACCESSIBLE>");
                return 0L;
            }
            long total = 0L;
            List<File> fileList = Arrays.asList(files);
            Collections.sort(fileList, new Comparator<File>(){

                @Override
                public int compare(File o1, File o2) {
                    return o1.getName().compareTo(o2.getName());
                }
            });
            for (File file : fileList) {
                long size;
                String filename = file.getName();
                if (file.isDirectory()) {
                    logger.log(prefix + filename + ":");
                    size = this.logStoreFiles(logger, prefix + "  ", file, mappedCounter);
                    filename = "- Total";
                } else {
                    size = file.length();
                    mappedCounter.addFile(file);
                }
                String fileModificationDate = this.getFileModificationDate(file);
                String bytes = Format.bytes(size);
                String fileInformation = String.format("%s%s: %s - %s", prefix, filename, fileModificationDate, bytes);
                logger.log(fileInformation);
                total += size;
            }
            return total;
        }

        private String getFileModificationDate(File file) {
            Date modifiedDate = new Date(file.lastModified());
            return this.dateFormat.format(modifiedDate);
        }

        private String getDiskSpace(File storeDir) {
            long free = storeDir.getFreeSpace();
            long total = storeDir.getTotalSpace();
            long percentage = total != 0L ? free * 100L / total : 0L;
            return String.format("Disk space on partition (Total / Free / Free %%): %s / %s / %s", total, free, percentage);
        }

        private static class MappedFileCounter {
            private long size;

            private MappedFileCounter() {
            }

            public void addFile(File file) {
                if (StoreType.shouldBeManagedByPageCache(file.getName())) {
                    this.size += file.length();
                }
            }

            public long getSize() {
                return this.size;
            }
        }
    }

    public static class Versions
    extends KernelDiagnostics {
        private final DatabaseInfo databaseInfo;
        private final StoreId storeId;

        public Versions(DatabaseInfo databaseInfo, StoreId storeId) {
            this.databaseInfo = databaseInfo;
            this.storeId = storeId;
        }

        @Override
        void dump(Logger logger) {
            logger.log("Graph Database: " + this.databaseInfo + " " + this.storeId);
            logger.log("Kernel version: " + Version.getKernelVersion());
        }
    }
}

