/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.storemigration.participant;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.StreamSupport;
import org.apache.commons.lang3.StringUtils;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.io.fs.FileHandle;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.io.pagecache.PagedFile;
import org.neo4j.kernel.api.AssertOpen;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.api.store.StorePropertyCursor;
import org.neo4j.kernel.impl.locking.LockService;
import org.neo4j.kernel.impl.logging.LogService;
import org.neo4j.kernel.impl.store.CountsComputer;
import org.neo4j.kernel.impl.store.MetaDataStore;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.store.NodeStore;
import org.neo4j.kernel.impl.store.RecordCursors;
import org.neo4j.kernel.impl.store.RecordStore;
import org.neo4j.kernel.impl.store.RelationshipStore;
import org.neo4j.kernel.impl.store.StoreFactory;
import org.neo4j.kernel.impl.store.StoreFile;
import org.neo4j.kernel.impl.store.StoreType;
import org.neo4j.kernel.impl.store.TransactionId;
import org.neo4j.kernel.impl.store.counts.CountsTracker;
import org.neo4j.kernel.impl.store.format.CapabilityType;
import org.neo4j.kernel.impl.store.format.FormatFamily;
import org.neo4j.kernel.impl.store.format.RecordFormatSelector;
import org.neo4j.kernel.impl.store.format.RecordFormats;
import org.neo4j.kernel.impl.store.format.StoreVersion;
import org.neo4j.kernel.impl.store.format.standard.StandardV2_3;
import org.neo4j.kernel.impl.store.format.standard.StandardV3_0;
import org.neo4j.kernel.impl.store.id.ReadOnlyIdGeneratorFactory;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.store.record.PrimitiveRecord;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;
import org.neo4j.kernel.impl.storemigration.DirectRecordStoreMigrator;
import org.neo4j.kernel.impl.storemigration.ExistingTargetStrategy;
import org.neo4j.kernel.impl.storemigration.FileOperation;
import org.neo4j.kernel.impl.storemigration.StoreFileType;
import org.neo4j.kernel.impl.storemigration.legacylogs.LegacyLogs;
import org.neo4j.kernel.impl.storemigration.monitoring.MigrationProgressMonitor;
import org.neo4j.kernel.impl.storemigration.monitoring.SilentMigrationProgressMonitor;
import org.neo4j.kernel.impl.storemigration.participant.AbstractStoreMigrationParticipant;
import org.neo4j.kernel.impl.storemigration.participant.StoreScanAsInputIterable;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.PhysicalLogFiles;
import org.neo4j.kernel.impl.util.CustomIOConfigValidator;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.kernel.lifecycle.Lifespan;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.unsafe.impl.batchimport.AdditionalInitialIds;
import org.neo4j.unsafe.impl.batchimport.Configuration;
import org.neo4j.unsafe.impl.batchimport.InputIterable;
import org.neo4j.unsafe.impl.batchimport.ParallelBatchImporter;
import org.neo4j.unsafe.impl.batchimport.cache.idmapping.IdGenerators;
import org.neo4j.unsafe.impl.batchimport.cache.idmapping.IdMappers;
import org.neo4j.unsafe.impl.batchimport.input.Collectors;
import org.neo4j.unsafe.impl.batchimport.input.InputEntity;
import org.neo4j.unsafe.impl.batchimport.input.InputNode;
import org.neo4j.unsafe.impl.batchimport.input.InputRelationship;
import org.neo4j.unsafe.impl.batchimport.input.Inputs;
import org.neo4j.unsafe.impl.batchimport.staging.CoarseBoundedProgressExecutionMonitor;
import org.neo4j.unsafe.impl.batchimport.staging.ExecutionMonitor;
import org.neo4j.unsafe.impl.batchimport.staging.ExecutionSupervisors;

public class StoreMigrator
extends AbstractStoreMigrationParticipant {
    private static final char TX_LOG_COUNTERS_SEPARATOR = 'A';
    public static final String CUSTOM_IO_EXCEPTION_MESSAGE = "Migrating this version is not supported for custom IO configurations.";
    private final Config config;
    private final LogService logService;
    private final LegacyLogs legacyLogs;
    private final FileSystemAbstraction fileSystem;
    private final PageCache pageCache;

    public StoreMigrator(FileSystemAbstraction fileSystem, PageCache pageCache, Config config, LogService logService) {
        this(fileSystem, pageCache, config, logService, new LegacyLogs(fileSystem));
    }

    public StoreMigrator(FileSystemAbstraction fileSystem, PageCache pageCache, Config config, LogService logService, LegacyLogs legacyLogs) {
        super("Store files");
        this.fileSystem = fileSystem;
        this.pageCache = pageCache;
        this.config = config;
        this.logService = logService;
        this.legacyLogs = legacyLogs;
    }

    @Override
    public void migrate(File storeDir, File migrationDir, MigrationProgressMonitor.Section progressMonitor, String versionToMigrateFrom, String versionToMigrateTo) throws IOException {
        if (versionToMigrateFrom.equals(StandardV2_3.STORE_VERSION)) {
            CustomIOConfigValidator.assertCustomIOConfigNotUsed(this.config, CUSTOM_IO_EXCEPTION_MESSAGE);
        }
        File neoStore = new File(storeDir, "neostore");
        long lastTxId = MetaDataStore.getRecord(this.pageCache, neoStore, MetaDataStore.Position.LAST_TRANSACTION_ID);
        TransactionId lastTxInfo = this.extractTransactionIdInformation(neoStore, storeDir, lastTxId);
        LogPosition lastTxLogPosition = this.extractTransactionLogPosition(neoStore, storeDir, lastTxId);
        this.writeLastTxInformation(migrationDir, lastTxInfo);
        this.writeLastTxLogPosition(migrationDir, lastTxLogPosition);
        if (versionToMigrateFrom.equals("vE.H.0")) {
            versionToMigrateFrom = "vE.H.0b";
        }
        RecordFormats oldFormat = RecordFormatSelector.selectForVersion(versionToMigrateFrom);
        RecordFormats newFormat = RecordFormatSelector.selectForVersion(versionToMigrateTo);
        if (FormatFamily.isHigherFamilyFormat(newFormat, oldFormat) || FormatFamily.isSameFamily(oldFormat, newFormat) && this.isDifferentCapabilities(oldFormat, newFormat)) {
            this.migrateWithBatchImporter(storeDir, migrationDir, lastTxId, lastTxInfo.checksum(), lastTxLogPosition.getLogVersion(), lastTxLogPosition.getByteOffset(), progressMonitor, oldFormat, newFormat);
        }
    }

    private boolean isDifferentCapabilities(RecordFormats oldFormat, RecordFormats newFormat) {
        return !oldFormat.hasSameCapabilities(newFormat, CapabilityType.FORMAT);
    }

    void writeLastTxInformation(File migrationDir, TransactionId txInfo) throws IOException {
        StoreMigrator.writeTxLogCounters(this.fileSystem, StoreMigrator.lastTxInformationFile(migrationDir), txInfo.transactionId(), txInfo.checksum(), txInfo.commitTimestamp());
    }

    void writeLastTxLogPosition(File migrationDir, LogPosition lastTxLogPosition) throws IOException {
        StoreMigrator.writeTxLogCounters(this.fileSystem, StoreMigrator.lastTxLogPositionFile(migrationDir), lastTxLogPosition.getLogVersion(), lastTxLogPosition.getByteOffset());
    }

    TransactionId readLastTxInformation(File migrationDir) throws IOException {
        long[] counters = StoreMigrator.readTxLogCounters(this.fileSystem, StoreMigrator.lastTxInformationFile(migrationDir), 3);
        return new TransactionId(counters[0], counters[1], counters[2]);
    }

    LogPosition readLastTxLogPosition(File migrationDir) throws IOException {
        long[] counters = StoreMigrator.readTxLogCounters(this.fileSystem, StoreMigrator.lastTxLogPositionFile(migrationDir), 2);
        return new LogPosition(counters[0], counters[1]);
    }

    private static void writeTxLogCounters(FileSystemAbstraction fs, File file, long ... counters) throws IOException {
        try (Writer writer = fs.openAsWriter(file, StandardCharsets.UTF_8, false);){
            writer.write(StringUtils.join((long[])counters, (char)'A'));
        }
    }

    private static long[] readTxLogCounters(FileSystemAbstraction fs, File file, int numberOfCounters) throws IOException {
        try (BufferedReader reader = new BufferedReader(fs.openAsReader(file, StandardCharsets.UTF_8));){
            String line = reader.readLine();
            String[] split = StringUtils.split((String)line, (char)'A');
            if (split.length != numberOfCounters) {
                throw new IllegalArgumentException("Unexpected number of tx counters '" + numberOfCounters + "', file contains: '" + line + "'");
            }
            long[] counters = new long[numberOfCounters];
            for (int i = 0; i < split.length; ++i) {
                counters[i] = Long.parseLong(split[i]);
            }
            long[] lArray = counters;
            return lArray;
        }
    }

    private static File lastTxInformationFile(File migrationDir) {
        return new File(migrationDir, "lastxinformation");
    }

    private static File lastTxLogPositionFile(File migrationDir) {
        return new File(migrationDir, "lastxlogposition");
    }

    TransactionId extractTransactionIdInformation(File neoStore, File storeDir, long lastTransactionId) throws IOException {
        long checksum = MetaDataStore.getRecord(this.pageCache, neoStore, MetaDataStore.Position.LAST_TRANSACTION_CHECKSUM);
        long commitTimestamp = MetaDataStore.getRecord(this.pageCache, neoStore, MetaDataStore.Position.LAST_TRANSACTION_COMMIT_TIMESTAMP);
        if (checksum != -1L && commitTimestamp != -1L) {
            return new TransactionId(lastTransactionId, checksum, commitTimestamp);
        }
        Optional<TransactionId> transactionInformation = this.legacyLogs.getTransactionInformation(storeDir, lastTransactionId);
        return transactionInformation.orElseGet(this.specificTransactionInformationSupplier(lastTransactionId));
    }

    private Supplier<TransactionId> specificTransactionInformationSupplier(long lastTransactionId) {
        return () -> lastTransactionId == 1L ? new TransactionId(lastTransactionId, 0L, 0L) : new TransactionId(lastTransactionId, 1L, 1L);
    }

    private LogPosition extractTransactionLogPosition(File neoStore, File storeDir, long lastTxId) throws IOException {
        long lastClosedTxLogVersion = MetaDataStore.getRecord(this.pageCache, neoStore, MetaDataStore.Position.LAST_CLOSED_TRANSACTION_LOG_VERSION);
        long lastClosedTxLogByteOffset = MetaDataStore.getRecord(this.pageCache, neoStore, MetaDataStore.Position.LAST_CLOSED_TRANSACTION_LOG_BYTE_OFFSET);
        if (lastClosedTxLogVersion != -1L && lastClosedTxLogByteOffset != -1L) {
            return new LogPosition(lastClosedTxLogVersion, lastClosedTxLogByteOffset);
        }
        if (lastTxId == 1L) {
            return new LogPosition(0L, 16L);
        }
        PhysicalLogFiles logFiles = new PhysicalLogFiles(storeDir, this.fileSystem);
        long logVersion = logFiles.getHighestLogVersion();
        if (logVersion == -1L) {
            return new LogPosition(0L, 16L);
        }
        long offset = this.fileSystem.getFileSize(logFiles.getLogFileForVersion(logVersion));
        return new LogPosition(logVersion, offset);
    }

    private void migrateWithBatchImporter(File storeDir, File migrationDir, long lastTxId, long lastTxChecksum, long lastTxLogVersion, long lastTxLogByteOffset, MigrationProgressMonitor.Section progressMonitor, RecordFormats oldFormat, RecordFormats newFormat) throws IOException {
        this.prepareBatchImportMigration(storeDir, migrationDir, oldFormat, newFormat);
        boolean requiresDynamicStoreMigration = !newFormat.dynamic().equals(oldFormat.dynamic());
        boolean requiresPropertyMigration = !newFormat.property().equals(oldFormat.property()) || requiresDynamicStoreMigration;
        File badFile = new File(storeDir, "bad.log");
        try (NeoStores legacyStore = this.instantiateLegacyStore(oldFormat, storeDir);
             RecordCursors nodeInputCursors = new RecordCursors(legacyStore);
             RecordCursors relationshipInputCursors = new RecordCursors(legacyStore);
             BufferedOutputStream badOutput = new BufferedOutputStream(new FileOutputStream(badFile, false));){
            Configuration.Overridden importConfig = new Configuration.Overridden(this.config);
            AdditionalInitialIds additionalInitialIds = this.readAdditionalIds(lastTxId, lastTxChecksum, lastTxLogVersion, lastTxLogByteOffset);
            ParallelBatchImporter importer = new ParallelBatchImporter(migrationDir.getAbsoluteFile(), this.fileSystem, this.pageCache, importConfig, this.logService, ExecutionSupervisors.withDynamicProcessorAssignment(this.migrationBatchImporterMonitor(legacyStore, progressMonitor, importConfig), importConfig), additionalInitialIds, this.config, newFormat);
            InputIterable<InputNode> nodes = this.legacyNodesAsInput(legacyStore, requiresPropertyMigration, nodeInputCursors);
            InputIterable<InputRelationship> relationships = this.legacyRelationshipsAsInput(legacyStore, requiresPropertyMigration, relationshipInputCursors);
            importer.doImport(Inputs.input(nodes, relationships, IdMappers.actual(), IdGenerators.fromInput(), Collectors.badCollector(badOutput, 0)));
            ArrayList<StoreFile> storesToDeleteFromMigratedDirectory = new ArrayList<StoreFile>();
            storesToDeleteFromMigratedDirectory.add(StoreFile.NEO_STORE);
            if (!requiresPropertyMigration) {
                storesToDeleteFromMigratedDirectory.addAll(Arrays.asList(StoreFile.PROPERTY_STORE, StoreFile.PROPERTY_STRING_STORE, StoreFile.PROPERTY_ARRAY_STORE));
            }
            if (!requiresDynamicStoreMigration) {
                storesToDeleteFromMigratedDirectory.addAll(Arrays.asList(StoreFile.NODE_LABEL_STORE, StoreFile.LABEL_TOKEN_STORE, StoreFile.LABEL_TOKEN_NAMES_STORE, StoreFile.RELATIONSHIP_TYPE_TOKEN_STORE, StoreFile.RELATIONSHIP_TYPE_TOKEN_NAMES_STORE, StoreFile.PROPERTY_KEY_TOKEN_STORE, StoreFile.PROPERTY_KEY_TOKEN_NAMES_STORE, StoreFile.SCHEMA_STORE));
            }
            StoreFile.fileOperation(FileOperation.DELETE, this.fileSystem, migrationDir, null, storesToDeleteFromMigratedDirectory, true, null, StoreFileType.values());
            try {
                Predicate<FileHandle> fileHandlePredicate = fileHandle -> storesToDeleteFromMigratedDirectory.stream().anyMatch(storeFile -> storeFile.fileName(StoreFileType.STORE).equals(fileHandle.getFile().getName()));
                this.pageCache.getCachedFileSystem().streamFilesRecursive(migrationDir).filter(fileHandlePredicate).forEach(FileHandle.HANDLE_DELETE);
            }
            catch (NoSuchFileException noSuchFileException) {
                // empty catch block
            }
        }
    }

    private NeoStores instantiateLegacyStore(RecordFormats format, File storeDir) {
        return new StoreFactory(storeDir, this.config, new ReadOnlyIdGeneratorFactory(), this.pageCache, this.fileSystem, format, (LogProvider)NullLogProvider.getInstance()).openAllNeoStores(true);
    }

    private void prepareBatchImportMigration(File storeDir, File migrationDir, RecordFormats oldFormat, RecordFormats newFormat) throws IOException {
        this.createStore(migrationDir, newFormat);
        StoreFile[] storesFilesToMigrate = new StoreFile[]{StoreFile.LABEL_TOKEN_STORE, StoreFile.LABEL_TOKEN_NAMES_STORE, StoreFile.PROPERTY_KEY_TOKEN_STORE, StoreFile.PROPERTY_KEY_TOKEN_NAMES_STORE, StoreFile.RELATIONSHIP_TYPE_TOKEN_STORE, StoreFile.RELATIONSHIP_TYPE_TOKEN_NAMES_STORE, StoreFile.NODE_LABEL_STORE};
        if (newFormat.dynamic().equals(oldFormat.dynamic())) {
            for (StoreFile file : storesFilesToMigrate) {
                File fromPath = new File(storeDir, file.fileName(StoreFileType.STORE));
                File toPath = new File(migrationDir, file.fileName(StoreFileType.STORE));
                int pageSize = this.pageCache.pageSize();
                try (PagedFile fromFile = this.pageCache.map(fromPath, pageSize, new OpenOption[0]);
                     PagedFile toFile = this.pageCache.map(toPath, pageSize, new OpenOption[]{StandardOpenOption.CREATE});
                     PageCursor fromCursor = fromFile.io(0L, 1);
                     PageCursor toCursor = toFile.io(0L, 2);){
                    while (fromCursor.next()) {
                        toCursor.next();
                        do {
                            fromCursor.copyTo(0, toCursor, 0, pageSize);
                        } while (fromCursor.shouldRetry());
                    }
                }
                catch (NoSuchFileException noSuchFileException) {
                    // empty catch block
                }
            }
            StoreFile.fileOperation(FileOperation.COPY, this.fileSystem, storeDir, migrationDir, Arrays.asList(storesFilesToMigrate), true, ExistingTargetStrategy.FAIL, StoreFileType.ID);
        } else {
            DirectRecordStoreMigrator migrator = new DirectRecordStoreMigrator(this.pageCache, this.fileSystem, this.config);
            StoreType[] storesToMigrate = new StoreType[]{StoreType.LABEL_TOKEN, StoreType.LABEL_TOKEN_NAME, StoreType.PROPERTY_KEY_TOKEN, StoreType.PROPERTY_KEY_TOKEN_NAME, StoreType.RELATIONSHIP_TYPE_TOKEN, StoreType.RELATIONSHIP_TYPE_TOKEN_NAME, StoreType.NODE_LABEL, StoreType.SCHEMA};
            MigrationProgressMonitor.Section section = SilentMigrationProgressMonitor.NO_OP_SECTION;
            migrator.migrate(storeDir, oldFormat, migrationDir, newFormat, section, storesToMigrate, StoreType.NODE);
        }
    }

    private void createStore(File migrationDir, RecordFormats newFormat) {
        StoreFactory storeFactory = new StoreFactory(new File(migrationDir.getPath()), this.pageCache, this.fileSystem, newFormat, (LogProvider)NullLogProvider.getInstance());
        try (NeoStores neoStores = storeFactory.openAllNeoStores(true);){
            neoStores.getMetaDataStore();
            neoStores.getLabelTokenStore();
            neoStores.getNodeStore();
            neoStores.getPropertyStore();
            neoStores.getRelationshipGroupStore();
            neoStores.getRelationshipStore();
            neoStores.getSchemaStore();
        }
    }

    private AdditionalInitialIds readAdditionalIds(final long lastTxId, final long lastTxChecksum, final long lastTxLogVersion, final long lastTxLogByteOffset) throws IOException {
        return new AdditionalInitialIds(){

            @Override
            public long lastCommittedTransactionId() {
                return lastTxId;
            }

            @Override
            public long lastCommittedTransactionChecksum() {
                return lastTxChecksum;
            }

            @Override
            public long lastCommittedTransactionLogVersion() {
                return lastTxLogVersion;
            }

            @Override
            public long lastCommittedTransactionLogByteOffset() {
                return lastTxLogByteOffset;
            }
        };
    }

    private ExecutionMonitor migrationBatchImporterMonitor(NeoStores legacyStore, MigrationProgressMonitor.Section progressMonitor, Configuration config) {
        return new BatchImporterProgressMonitor(legacyStore.getNodeStore().getHighId(), legacyStore.getRelationshipStore().getHighId(), config, progressMonitor);
    }

    private InputIterable<InputRelationship> legacyRelationshipsAsInput(NeoStores legacyStore, boolean requiresPropertyMigration, RecordCursors cursors) {
        RelationshipStore store = legacyStore.getRelationshipStore();
        final BiConsumer propertyDecorator = this.propertyDecorator(requiresPropertyMigration, cursors);
        return new StoreScanAsInputIterable<InputRelationship, RelationshipRecord>((RecordStore)store){

            @Override
            protected InputRelationship inputEntityOf(RelationshipRecord record) {
                InputRelationship result = new InputRelationship("legacy store", record.getId(), record.getId() * 34L, InputEntity.NO_PROPERTIES, record.getNextProp(), record.getFirstNode(), record.getSecondNode(), null, record.getType());
                propertyDecorator.accept(result, record);
                return result;
            }
        };
    }

    private InputIterable<InputNode> legacyNodesAsInput(NeoStores legacyStore, boolean requiresPropertyMigration, RecordCursors cursors) {
        NodeStore store = legacyStore.getNodeStore();
        final BiConsumer propertyDecorator = this.propertyDecorator(requiresPropertyMigration, cursors);
        return new StoreScanAsInputIterable<InputNode, NodeRecord>((RecordStore)store){

            @Override
            protected InputNode inputEntityOf(NodeRecord record) {
                InputNode node = new InputNode("legacy store", record.getId(), record.getId() * 15L, record.getId(), InputEntity.NO_PROPERTIES, record.getNextProp(), InputNode.NO_LABELS, record.getLabelField());
                propertyDecorator.accept(node, record);
                return node;
            }
        };
    }

    private <ENTITY extends InputEntity, RECORD extends PrimitiveRecord> BiConsumer<ENTITY, RECORD> propertyDecorator(boolean requiresPropertyMigration, RecordCursors cursors) {
        if (!requiresPropertyMigration) {
            return (a, b) -> {};
        }
        StorePropertyCursor cursor = new StorePropertyCursor(cursors, ignored -> {});
        ArrayList scratch = new ArrayList();
        return (entity, record) -> {
            cursor.init(record.getNextProp(), LockService.NO_LOCK, AssertOpen.ALWAYS_OPEN);
            scratch.clear();
            while (cursor.next()) {
                scratch.add(cursor.propertyKeyId());
                scratch.add(cursor.value());
            }
            entity.setProperties(scratch.isEmpty() ? InputEntity.NO_PROPERTIES : scratch.toArray());
            cursor.close();
        };
    }

    @Override
    public void moveMigratedFiles(File migrationDir, File storeDir, String versionToUpgradeFrom, String versionToUpgradeTo) throws IOException {
        StoreFile.fileOperation(FileOperation.MOVE, this.fileSystem, migrationDir, storeDir, StoreFile.currentStoreFiles(), true, ExistingTargetStrategy.OVERWRITE, StoreFileType.values());
        try {
            Iterable fileHandles = this.pageCache.getCachedFileSystem().streamFilesRecursive(migrationDir)::iterator;
            for (FileHandle fh : fileHandles) {
                Predicate<StoreFile> predicate = storeFile -> storeFile.fileName(StoreFileType.STORE).equals(fh.getFile().getName());
                if (!StreamSupport.stream(StoreFile.currentStoreFiles().spliterator(), false).anyMatch(predicate)) continue;
                Optional optionalPagedFile = this.pageCache.getExistingMapping(fh.getFile());
                if (optionalPagedFile.isPresent()) {
                    ((PagedFile)optionalPagedFile.get()).close();
                }
                fh.rename(new File(storeDir, fh.getFile().getName()), new CopyOption[]{StandardCopyOption.REPLACE_EXISTING});
            }
        }
        catch (NoSuchFileException fileHandles) {
            // empty catch block
        }
        LogPosition logPosition = this.readLastTxLogPosition(migrationDir);
        this.updateOrAddNeoStoreFieldsAsPartOfMigration(migrationDir, storeDir, versionToUpgradeTo, logPosition);
        this.legacyLogs.deleteUnusedLogFiles(storeDir);
    }

    @Override
    public void rebuildCounts(File storeDir, String versionToMigrateFrom, String versionToMigrateTo) throws IOException {
        if (this.countStoreRebuildRequired(versionToMigrateFrom)) {
            Iterable countsStoreFiles = Iterables.iterable((Object[])new StoreFile[]{StoreFile.COUNTS_STORE_LEFT, StoreFile.COUNTS_STORE_RIGHT});
            StoreFile.fileOperation(FileOperation.DELETE, this.fileSystem, storeDir, storeDir, countsStoreFiles, true, null, StoreFileType.STORE);
            File neoStore = new File(storeDir, "neostore");
            long lastTxId = MetaDataStore.getRecord(this.pageCache, neoStore, MetaDataStore.Position.LAST_TRANSACTION_ID);
            this.rebuildCountsFromScratch(storeDir, lastTxId, versionToMigrateTo, this.pageCache);
        }
    }

    boolean countStoreRebuildRequired(String versionToMigrateFrom) {
        return StandardV2_3.STORE_VERSION.equals(versionToMigrateFrom) || StandardV3_0.STORE_VERSION.equals(versionToMigrateFrom) || StoreVersion.HIGH_LIMIT_V3_0_0.versionString().equals(versionToMigrateFrom) || StoreVersion.HIGH_LIMIT_V3_0_6.versionString().equals(versionToMigrateFrom) || StoreVersion.HIGH_LIMIT_V3_1_0.versionString().equals(versionToMigrateFrom);
    }

    private void rebuildCountsFromScratch(File storeDir, long lastTxId, String versionToMigrateTo, PageCache pageCache) {
        File storeFileBase = new File(storeDir, "neostore.counts.db");
        RecordFormats recordFormats = RecordFormatSelector.selectForVersion(versionToMigrateTo);
        StoreFactory storeFactory = new StoreFactory(storeDir, pageCache, this.fileSystem, recordFormats, (LogProvider)NullLogProvider.getInstance());
        try (NeoStores neoStores = storeFactory.openAllNeoStores();){
            NodeStore nodeStore = neoStores.getNodeStore();
            RelationshipStore relationshipStore = neoStores.getRelationshipStore();
            try (Lifespan life = new Lifespan(new Lifecycle[0]);){
                int highLabelId = (int)neoStores.getLabelTokenStore().getHighId();
                int highRelationshipTypeId = (int)neoStores.getRelationshipTypeTokenStore().getHighId();
                CountsComputer initializer = new CountsComputer(lastTxId, nodeStore, relationshipStore, highLabelId, highRelationshipTypeId);
                life.add((Lifecycle)new CountsTracker(this.logService.getInternalLogProvider(), this.fileSystem, pageCache, this.config, storeFileBase).setInitializer(initializer));
            }
        }
    }

    private void updateOrAddNeoStoreFieldsAsPartOfMigration(File migrationDir, File storeDir, String versionToMigrateTo, LogPosition lastClosedTxLogPosition) throws IOException {
        File storeDirNeoStore = new File(storeDir, "neostore");
        MetaDataStore.setRecord(this.pageCache, storeDirNeoStore, MetaDataStore.Position.UPGRADE_TRANSACTION_ID, MetaDataStore.getRecord(this.pageCache, storeDirNeoStore, MetaDataStore.Position.LAST_TRANSACTION_ID));
        MetaDataStore.setRecord(this.pageCache, storeDirNeoStore, MetaDataStore.Position.UPGRADE_TIME, System.currentTimeMillis());
        TransactionId lastTxInfo = this.readLastTxInformation(migrationDir);
        MetaDataStore.setRecord(this.pageCache, storeDirNeoStore, MetaDataStore.Position.LAST_TRANSACTION_CHECKSUM, lastTxInfo.checksum());
        MetaDataStore.setRecord(this.pageCache, storeDirNeoStore, MetaDataStore.Position.UPGRADE_TRANSACTION_CHECKSUM, lastTxInfo.checksum());
        MetaDataStore.setRecord(this.pageCache, storeDirNeoStore, MetaDataStore.Position.LAST_TRANSACTION_COMMIT_TIMESTAMP, lastTxInfo.commitTimestamp());
        MetaDataStore.setRecord(this.pageCache, storeDirNeoStore, MetaDataStore.Position.UPGRADE_TRANSACTION_COMMIT_TIMESTAMP, lastTxInfo.commitTimestamp());
        MetaDataStore.setRecord(this.pageCache, storeDirNeoStore, MetaDataStore.Position.LAST_CLOSED_TRANSACTION_LOG_VERSION, lastClosedTxLogPosition.getLogVersion());
        MetaDataStore.setRecord(this.pageCache, storeDirNeoStore, MetaDataStore.Position.LAST_CLOSED_TRANSACTION_LOG_BYTE_OFFSET, lastClosedTxLogPosition.getByteOffset());
        MetaDataStore.setRecord(this.pageCache, storeDirNeoStore, MetaDataStore.Position.STORE_VERSION, MetaDataStore.versionStringToLong(versionToMigrateTo));
    }

    @Override
    public void cleanup(File migrationDir) throws IOException {
        this.fileSystem.deleteRecursively(migrationDir);
    }

    public String toString() {
        return "Kernel StoreMigrator";
    }

    private class BatchImporterProgressMonitor
    extends CoarseBoundedProgressExecutionMonitor {
        private final MigrationProgressMonitor.Section progressMonitor;

        BatchImporterProgressMonitor(long highNodeId, long highRelationshipId, Configuration configuration, MigrationProgressMonitor.Section progressMonitor) {
            super(highNodeId, highRelationshipId, configuration);
            this.progressMonitor = progressMonitor;
            this.progressMonitor.start(this.total());
        }

        @Override
        protected void progress(long progress) {
            this.progressMonitor.progress(progress);
        }
    }
}

