/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store.id;

import java.util.Arrays;
import org.neo4j.collection.primitive.PrimitiveLongCollections;
import org.neo4j.kernel.impl.store.id.IdRange;

public class IdRangeIterator {
    public static IdRangeIterator EMPTY_ID_RANGE_ITERATOR = new IdRangeIterator(new IdRange(PrimitiveLongCollections.EMPTY_LONG_ARRAY, 0L, 0)){

        @Override
        public long next() {
            return -1L;
        }
    };
    public static final long VALUE_REPRESENTING_NULL = -1L;
    private int position;
    private final long[] defrag;
    private final long start;
    private final int length;

    public IdRangeIterator(IdRange idRange) {
        this.defrag = idRange.getDefragIds();
        this.start = idRange.getRangeStart();
        this.length = idRange.getRangeLength();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long next() {
        try {
            if (this.position < this.defrag.length) {
                long l = this.defrag[this.position];
                return l;
            }
            long candidate = this.nextRangeCandidate();
            if (candidate == 0xFFFFFFFFL) {
                ++this.position;
                candidate = this.nextRangeCandidate();
            }
            long l = candidate;
            return l;
        }
        finally {
            ++this.position;
        }
    }

    private long nextRangeCandidate() {
        int offset = this.position - this.defrag.length;
        return offset < this.length ? this.start + (long)offset : -1L;
    }

    public String toString() {
        return "IdRangeIterator[start:" + this.start + ", length:" + this.length + ", position:" + this.position + ", defrag:" + Arrays.toString(this.defrag) + "]";
    }
}

