/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store.id;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.OffsetChannel;
import org.neo4j.io.fs.StoreChannel;
import org.neo4j.kernel.impl.store.InvalidIdGeneratorException;
import org.neo4j.kernel.impl.store.UnderlyingStorageException;
import org.neo4j.kernel.impl.store.id.FreeIdKeeper;
import org.neo4j.kernel.impl.store.id.IdRange;

public class IdContainer {
    public static final long NO_RESULT = -1L;
    static final int HEADER_SIZE = 9;
    private static final byte CLEAN_GENERATOR = 0;
    private static final byte STICKY_GENERATOR = 1;
    private final File file;
    private final FileSystemAbstraction fs;
    private StoreChannel fileChannel;
    private boolean closed = true;
    private final int grabSize;
    private final boolean aggressiveReuse;
    private FreeIdKeeper freeIdKeeper;
    private long initialHighId;

    public IdContainer(FileSystemAbstraction fs, File file, int grabSize, boolean aggressiveReuse) {
        if (grabSize < 1) {
            throw new IllegalArgumentException("Illegal grabSize: " + grabSize);
        }
        this.file = file;
        this.fs = fs;
        this.grabSize = grabSize;
        this.aggressiveReuse = aggressiveReuse;
    }

    public boolean init() {
        boolean result = true;
        try {
            if (!this.fs.fileExists(this.file)) {
                IdContainer.createEmptyIdFile(this.fs, this.file, 0L, false);
                result = false;
            }
            this.fileChannel = this.fs.open(this.file, "rw");
            this.initialHighId = this.readAndValidateHeader();
            this.markAsSticky();
            this.freeIdKeeper = new FreeIdKeeper((StoreChannel)new OffsetChannel(this.fileChannel, 9L), this.grabSize, this.aggressiveReuse);
            this.closed = false;
        }
        catch (IOException e) {
            throw new UnderlyingStorageException("Unable to init id file " + this.file, e);
        }
        return result;
    }

    public boolean isClosed() {
        return this.closed;
    }

    long getInitialHighId() {
        return this.initialHighId;
    }

    void assertStillOpen() {
        if (this.closed) {
            throw new IllegalStateException("Closed id file " + this.file);
        }
    }

    private long readAndValidateHeader() throws IOException {
        try {
            return IdContainer.readAndValidate(this.fileChannel, this.file);
        }
        catch (InvalidIdGeneratorException e) {
            this.fileChannel.close();
            throw e;
        }
    }

    private static long readAndValidate(StoreChannel channel, File fileName) throws IOException {
        ByteBuffer buffer = ByteBuffer.allocate(9);
        int read = channel.read(buffer);
        if (read != 9) {
            throw new InvalidIdGeneratorException("Unable to read header, bytes read: " + read);
        }
        buffer.flip();
        byte storageStatus = buffer.get();
        if (storageStatus != 0) {
            throw new InvalidIdGeneratorException("Id file not properly shutdown [ " + fileName + " ], delete this id file and build a new one");
        }
        return buffer.getLong();
    }

    static long readHighId(FileSystemAbstraction fileSystem, File file) throws IOException {
        try (StoreChannel channel = fileSystem.open(file, "r");){
            long l = IdContainer.readAndValidate(channel, file);
            return l;
        }
    }

    private void markAsSticky() throws IOException {
        ByteBuffer buffer = ByteBuffer.allocate(1);
        buffer.put((byte)1).flip();
        this.fileChannel.position(0L);
        this.fileChannel.write(buffer);
        this.fileChannel.force(false);
    }

    private void markAsCleanlyClosed() throws IOException {
        ByteBuffer buffer = ByteBuffer.allocate(1);
        buffer.put((byte)0).flip();
        this.fileChannel.position(0L);
        this.fileChannel.write(buffer);
    }

    public void close(long highId) {
        if (!this.closed) {
            try {
                this.freeIdKeeper.close();
                this.writeHeader(highId);
                this.markAsCleanlyClosed();
                this.closeChannel();
            }
            catch (IOException e) {
                throw new UnderlyingStorageException("Unable to close id file " + this.file, e);
            }
        }
    }

    private void closeChannel() throws IOException {
        this.fileChannel.force(false);
        this.fileChannel.close();
        this.fileChannel = null;
        this.closed = true;
    }

    private void writeHeader(long highId) throws IOException {
        ByteBuffer buffer = ByteBuffer.allocate(9);
        buffer.put((byte)1).putLong(highId).flip();
        this.fileChannel.position(0L);
        this.fileChannel.write(buffer);
    }

    public void delete() {
        if (!this.closed) {
            try {
                this.closeChannel();
            }
            catch (IOException e) {
                throw new UnderlyingStorageException("Unable to close id file " + this.file, e);
            }
        }
        if (!this.fs.deleteFile(this.file)) {
            throw new UnderlyingStorageException("Unable to delete id file " + this.file);
        }
    }

    public long getReusableId() {
        return this.freeIdKeeper.getId();
    }

    public IdRange getReusableIdBatch(int maxSize) {
        long id;
        long[] tmpIdArr = new long[maxSize];
        int count = 0;
        while (count < maxSize && (id = this.freeIdKeeper.getId()) != -1L) {
            tmpIdArr[count++] = id;
        }
        long[] defragIdArr = count == maxSize ? tmpIdArr : Arrays.copyOfRange(tmpIdArr, 0, count);
        return new IdRange(defragIdArr, 0L, 0);
    }

    public void freeId(long id) {
        this.freeIdKeeper.freeId(id);
    }

    public long getFreeIdCount() {
        return this.freeIdKeeper.getCount();
    }

    public static void createEmptyIdFile(FileSystemAbstraction fs, File file, long highId, boolean throwIfFileExists) {
        if (fs == null) {
            throw new IllegalArgumentException("Null filesystem");
        }
        if (file == null) {
            throw new IllegalArgumentException("Null filename");
        }
        if (throwIfFileExists && fs.fileExists(file)) {
            throw new IllegalStateException("Can't create id file [" + file + "], file already exists");
        }
        try (StoreChannel channel = fs.create(file);){
            channel.truncate(0L);
            ByteBuffer buffer = ByteBuffer.allocate(9);
            buffer.put((byte)0).putLong(highId).flip();
            channel.write(buffer);
            channel.force(false);
        }
        catch (IOException e) {
            throw new UnderlyingStorageException("Unable to create id file " + file, e);
        }
    }

    public String toString() {
        return "IdContainer{file=" + this.file + ", fs=" + this.fs + ", fileChannel=" + this.fileChannel + ", defragCount=" + this.freeIdKeeper.getCount() + ", grabSize=" + this.grabSize + ", aggressiveReuse=" + this.aggressiveReuse + ", closed=" + this.closed + '}';
    }
}

