/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.internal;

import org.neo4j.graphdb.event.ErrorState;
import org.neo4j.helpers.Exceptions;
import org.neo4j.kernel.impl.core.DatabasePanicEventGenerator;
import org.neo4j.logging.Log;

public class DatabaseHealth {
    private static final String panicMessage = "Database has encountered some problem, please perform necessary action (tx recovery/restart)";
    private volatile boolean tmOk = true;
    private final DatabasePanicEventGenerator dbpe;
    private final Log log;
    private Throwable causeOfPanic;

    public DatabaseHealth(DatabasePanicEventGenerator dbpe, Log log) {
        this.dbpe = dbpe;
        this.log = log;
    }

    public <EXCEPTION extends Throwable> void assertHealthy(Class<EXCEPTION> panicDisguise) throws EXCEPTION {
        if (!this.tmOk) {
            Throwable exception;
            try {
                try {
                    exception = (Throwable)panicDisguise.getConstructor(String.class, Throwable.class).newInstance(panicMessage, this.causeOfPanic);
                }
                catch (NoSuchMethodException e) {
                    exception = Exceptions.withCause((Throwable)((Throwable)panicDisguise.getConstructor(String.class).newInstance(panicMessage)), (Throwable)this.causeOfPanic);
                }
            }
            catch (Exception e) {
                throw new Error("Database has encountered some problem, please perform necessary action (tx recovery/restart). An exception of type " + panicDisguise.getName() + " was requested to be thrown but that proved impossible", e);
            }
            throw exception;
        }
    }

    public void panic(Throwable cause) {
        if (!this.tmOk) {
            return;
        }
        if (cause == null) {
            throw new IllegalArgumentException("Must provide a cause for the database panic");
        }
        this.causeOfPanic = cause;
        this.tmOk = false;
        this.log.error("Database panic: Database has encountered some problem, please perform necessary action (tx recovery/restart)", cause);
        this.dbpe.generateEvent(ErrorState.TX_MANAGER_NOT_OK, this.causeOfPanic);
    }

    public boolean isHealthy() {
        return this.tmOk;
    }

    public void healed() {
        this.tmOk = true;
        this.causeOfPanic = null;
        this.log.info("Database health set to OK");
    }

    public Throwable cause() {
        return this.causeOfPanic;
    }
}

