/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.query;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.neo4j.kernel.api.query.ExecutingQuery;
import org.neo4j.kernel.api.query.IndexUsage;
import org.neo4j.kernel.api.query.PageCounterValues;
import org.neo4j.kernel.api.query.PlannerInfo;
import org.neo4j.kernel.impl.query.clientconnection.ClientConnectionInfo;

public class QuerySnapshot {
    private final ExecutingQuery query;
    private final PlannerInfo plannerInfo;
    private final long planningTimeMillis;
    private final long elapsedTimeMillis;
    private final long cpuTimeMillis;
    private final long waitTimeMillis;
    private final String status;
    private final Map<String, Object> resourceInfo;
    private final long activeLockCount;
    private final long allocatedBytes;
    private final PageCounterValues page;

    QuerySnapshot(ExecutingQuery query, PlannerInfo plannerInfo, PageCounterValues page, long planningTimeMillis, long elapsedTimeMillis, long cpuTimeMillis, long waitTimeMillis, String status, Map<String, Object> resourceInfo, long activeLockCount, long allocatedBytes) {
        this.query = query;
        this.plannerInfo = plannerInfo;
        this.page = page;
        this.planningTimeMillis = planningTimeMillis;
        this.elapsedTimeMillis = elapsedTimeMillis;
        this.cpuTimeMillis = cpuTimeMillis;
        this.waitTimeMillis = waitTimeMillis;
        this.status = status;
        this.resourceInfo = resourceInfo;
        this.activeLockCount = activeLockCount;
        this.allocatedBytes = allocatedBytes;
    }

    public long internalQueryId() {
        return this.query.internalQueryId();
    }

    public String queryText() {
        return this.query.queryText();
    }

    public Map<String, Object> queryParameters() {
        return this.query.queryParameters();
    }

    public String username() {
        return this.query.username();
    }

    public ClientConnectionInfo clientConnection() {
        return this.query.clientConnection();
    }

    public Map<String, Object> transactionAnnotationData() {
        return this.query.transactionAnnotationData();
    }

    public long activeLockCount() {
        return this.activeLockCount;
    }

    public String planner() {
        return this.plannerInfo == null ? null : this.plannerInfo.planner();
    }

    public String runtime() {
        return this.plannerInfo == null ? null : this.plannerInfo.runtime();
    }

    public List<Map<String, String>> indexes() {
        if (this.plannerInfo == null) {
            return Collections.emptyList();
        }
        return this.plannerInfo.indexes().stream().map(IndexUsage::asMap).collect(Collectors.toList());
    }

    public String status() {
        return this.status;
    }

    public Map<String, Object> resourceInformation() {
        return this.resourceInfo;
    }

    public long startTimestampMillis() {
        return this.query.startTimestampMillis();
    }

    public long planningTimeMillis() {
        return this.planningTimeMillis;
    }

    public long waitTimeMillis() {
        return this.waitTimeMillis;
    }

    public long elapsedTimeMillis() {
        return this.elapsedTimeMillis;
    }

    public Long cpuTimeMillis() {
        return this.cpuTimeMillis < 0L ? null : Long.valueOf(this.cpuTimeMillis);
    }

    public Long idleTimeMillis() {
        return this.cpuTimeMillis < 0L ? null : Long.valueOf(this.elapsedTimeMillis - this.cpuTimeMillis - this.waitTimeMillis);
    }

    public Long allocatedBytes() {
        return this.allocatedBytes < 0L ? null : Long.valueOf(this.allocatedBytes);
    }

    public long pageHits() {
        return this.page.hits;
    }

    public long pageFaults() {
        return this.page.faults;
    }
}

