/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.helpers;

import java.util.concurrent.TimeUnit;
import java.util.function.Function;

public final class TimeUtil {
    public static final TimeUnit DEFAULT_TIME_UNIT = TimeUnit.SECONDS;
    public static final Function<String, Long> parseTimeMillis = timeWithOrWithoutUnit -> {
        TimeUnit timeUnit;
        int unitIndex = -1;
        for (int i = 0; i < timeWithOrWithoutUnit.length(); ++i) {
            char ch = timeWithOrWithoutUnit.charAt(i);
            if (Character.isDigit(ch)) continue;
            unitIndex = i;
            break;
        }
        if (unitIndex == -1) {
            return DEFAULT_TIME_UNIT.toMillis(Integer.parseInt(timeWithOrWithoutUnit));
        }
        int amount = Integer.parseInt(timeWithOrWithoutUnit.substring(0, unitIndex));
        String unit = timeWithOrWithoutUnit.substring(unitIndex).toLowerCase();
        if (unit.equals("ms")) {
            timeUnit = TimeUnit.MILLISECONDS;
        } else if (unit.equals("s")) {
            timeUnit = TimeUnit.SECONDS;
        } else if (unit.equals("m")) {
            timeUnit = TimeUnit.MINUTES;
        } else if (unit.equals("h")) {
            timeUnit = TimeUnit.HOURS;
        } else {
            throw new RuntimeException("Unrecognized unit " + unit);
        }
        return timeUnit.toMillis(amount);
    };

    public static String nanosToString(long nanos) {
        long microseconds;
        long milliseconds;
        long seconds;
        long minutes;
        long hours;
        assert (nanos >= 0L);
        long nanoSeconds = nanos;
        StringBuilder timeString = new StringBuilder();
        long days = TimeUnit.DAYS.convert(nanoSeconds, TimeUnit.NANOSECONDS);
        if (days > 0L) {
            nanoSeconds -= TimeUnit.DAYS.toNanos(days);
            timeString.append(days).append("d");
        }
        if ((hours = TimeUnit.HOURS.convert(nanoSeconds, TimeUnit.NANOSECONDS)) > 0L) {
            nanoSeconds -= TimeUnit.HOURS.toNanos(hours);
            timeString.append(hours).append("h");
        }
        if ((minutes = TimeUnit.MINUTES.convert(nanoSeconds, TimeUnit.NANOSECONDS)) > 0L) {
            nanoSeconds -= TimeUnit.MINUTES.toNanos(minutes);
            timeString.append(minutes).append("m");
        }
        if ((seconds = TimeUnit.SECONDS.convert(nanoSeconds, TimeUnit.NANOSECONDS)) > 0L) {
            nanoSeconds -= TimeUnit.SECONDS.toNanos(seconds);
            timeString.append(seconds).append("s");
        }
        if ((milliseconds = TimeUnit.MILLISECONDS.convert(nanoSeconds, TimeUnit.NANOSECONDS)) > 0L) {
            nanoSeconds -= TimeUnit.MILLISECONDS.toNanos(milliseconds);
            timeString.append(milliseconds).append("ms");
        }
        if ((microseconds = TimeUnit.MICROSECONDS.convert(nanoSeconds, TimeUnit.NANOSECONDS)) > 0L) {
            nanoSeconds -= TimeUnit.MICROSECONDS.toNanos(microseconds);
            timeString.append(microseconds).append("\u03bcs");
        }
        if (nanoSeconds > 0L || timeString.length() == 0) {
            timeString.append(nanoSeconds).append("ns");
        }
        return timeString.toString();
    }

    private TimeUtil() {
    }
}

