/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.core;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.neo4j.collection.primitive.PrimitiveIntIterator;
import org.neo4j.graphdb.ConstraintViolationException;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.NotFoundException;
import org.neo4j.kernel.api.ReadOperations;
import org.neo4j.kernel.api.Statement;
import org.neo4j.kernel.api.StatementTokenNameLookup;
import org.neo4j.kernel.api.exceptions.InvalidTransactionTypeKernelException;
import org.neo4j.kernel.api.exceptions.PropertyKeyIdNotFoundKernelException;
import org.neo4j.kernel.api.exceptions.PropertyNotFoundException;
import org.neo4j.kernel.api.exceptions.schema.IllegalTokenNameException;
import org.neo4j.kernel.api.properties.Property;
import org.neo4j.kernel.impl.core.GraphProperties;
import org.neo4j.storageengine.api.EntityType;

public class GraphPropertiesProxy
implements GraphProperties {
    private final GraphPropertiesActions actions;

    public GraphPropertiesProxy(GraphPropertiesActions actions) {
        this.actions = actions;
    }

    public GraphDatabaseService getGraphDatabase() {
        return this.actions.getGraphDatabaseService();
    }

    public boolean hasProperty(String key) {
        if (null == key) {
            return false;
        }
        try (Statement statement = this.actions.statement();){
            int propertyKeyId = statement.readOperations().propertyKeyGetForName(key);
            boolean bl = statement.readOperations().graphHasProperty(propertyKeyId);
            return bl;
        }
    }

    public Object getProperty(String key) {
        if (null == key) {
            throw new IllegalArgumentException("(null) property key is not allowed");
        }
        Throwable throwable = null;
        try (Statement statement = this.actions.statement();){
            int propertyKeyId = statement.readOperations().propertyKeyGetForName(key);
            if (propertyKeyId == -1) {
                throw new NotFoundException(String.format("No such property, '%s'.", key));
            }
            Object value = statement.readOperations().graphGetProperty(propertyKeyId);
            if (value == null) {
                throw new PropertyNotFoundException(propertyKeyId, EntityType.GRAPH, -1L);
            }
            Object object = value;
            return object;
        }
        catch (PropertyNotFoundException e) {
            try {
                throw new NotFoundException(e.getUserMessage(new StatementTokenNameLookup(statement.readOperations())), (Throwable)e);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    public Object getProperty(String key, Object defaultValue) {
        if (null == key) {
            throw new IllegalArgumentException("(null) property key is not allowed");
        }
        try (Statement statement = this.actions.statement();){
            int propertyKeyId = statement.readOperations().propertyKeyGetForName(key);
            Object value = statement.readOperations().graphGetProperty(propertyKeyId);
            Object object = value == null ? defaultValue : value;
            return object;
        }
    }

    public void setProperty(String key, Object value) {
        try (Statement statement = this.actions.statement();){
            int propertyKeyId = statement.tokenWriteOperations().propertyKeyGetOrCreateForName(key);
            try {
                statement.dataWriteOperations().graphSetProperty(Property.property(propertyKeyId, value));
            }
            catch (IllegalArgumentException e) {
                this.actions.failTransaction();
                throw e;
            }
        }
        catch (IllegalTokenNameException e) {
            throw new IllegalArgumentException(String.format("Invalid property key '%s'.", key), e);
        }
        catch (InvalidTransactionTypeKernelException e) {
            throw new ConstraintViolationException(e.getMessage(), (Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object removeProperty(String key) {
        try (Statement statement = this.actions.statement();){
            int propertyKeyId = statement.tokenWriteOperations().propertyKeyGetOrCreateForName(key);
            Object object = statement.dataWriteOperations().graphRemoveProperty(propertyKeyId).value(null);
            return object;
        }
        catch (IllegalTokenNameException e) {
            throw new IllegalArgumentException(String.format("Invalid property key '%s'.", key), e);
        }
        catch (InvalidTransactionTypeKernelException e) {
            throw new ConstraintViolationException(e.getMessage(), (Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Iterable<String> getPropertyKeys() {
        try (Statement statement = this.actions.statement();){
            ArrayList<String> keys = new ArrayList<String>();
            PrimitiveIntIterator properties = statement.readOperations().graphGetPropertyKeys();
            while (properties.hasNext()) {
                keys.add(statement.readOperations().propertyKeyGetName(properties.next()));
            }
            ArrayList<String> arrayList = keys;
            return arrayList;
        }
        catch (PropertyKeyIdNotFoundKernelException e) {
            throw new IllegalStateException("Property key retrieved through kernel API should exist.", e);
        }
    }

    public Map<String, Object> getProperties(String ... names) {
        try (Statement statement = this.actions.statement();){
            HashMap<String, Object> properties = new HashMap<String, Object>();
            ReadOperations readOperations = statement.readOperations();
            for (String name : names) {
                int propertyKeyId = readOperations.propertyKeyGetForName(name);
                Object value = readOperations.graphGetProperty(propertyKeyId);
                if (value == null) continue;
                properties.put(name, value);
            }
            HashMap<String, Object> hashMap = properties;
            return hashMap;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Map<String, Object> getAllProperties() {
        try (Statement statement = this.actions.statement();){
            HashMap<String, Object> properties = new HashMap<String, Object>();
            ReadOperations readOperations = statement.readOperations();
            PrimitiveIntIterator propertyKeys = readOperations.graphGetPropertyKeys();
            while (propertyKeys.hasNext()) {
                int propertyKeyId = propertyKeys.next();
                properties.put(readOperations.propertyKeyGetName(propertyKeyId), readOperations.graphGetProperty(propertyKeyId));
            }
            HashMap<String, Object> hashMap = properties;
            return hashMap;
        }
        catch (PropertyKeyIdNotFoundKernelException e) {
            throw new IllegalStateException("Property key retrieved through kernel API should exist.", e);
        }
    }

    public boolean equals(Object o) {
        return o instanceof GraphPropertiesProxy && this.actions.getGraphDatabaseService() == ((GraphPropertiesProxy)o).actions.getGraphDatabaseService();
    }

    public int hashCode() {
        return this.actions.getGraphDatabaseService().hashCode();
    }

    public static interface GraphPropertiesActions {
        public Statement statement();

        public GraphDatabaseService getGraphDatabaseService();

        public void failTransaction();
    }
}

