/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.proc;

import java.util.List;
import java.util.Map;
import org.neo4j.kernel.api.proc.Neo4jTypes;

public class Neo4jValue {
    private final Object value;
    private final Neo4jTypes.AnyType type;

    public Neo4jValue(Object value, Neo4jTypes.AnyType type) {
        this.value = value;
        this.type = type;
    }

    public Object value() {
        return this.value;
    }

    public Neo4jTypes.AnyType neo4jType() {
        return this.type;
    }

    public static Neo4jValue ntString(String value) {
        return new Neo4jValue(value, Neo4jTypes.NTString);
    }

    public static Neo4jValue ntInteger(long value) {
        return new Neo4jValue(value, Neo4jTypes.NTInteger);
    }

    public static Neo4jValue ntFloat(double value) {
        return new Neo4jValue(value, Neo4jTypes.NTFloat);
    }

    public static Neo4jValue ntBoolean(boolean value) {
        return new Neo4jValue(value, Neo4jTypes.NTBoolean);
    }

    public static Neo4jValue ntMap(Map<String, Object> value) {
        return new Neo4jValue(value, Neo4jTypes.NTMap);
    }

    public static Neo4jValue ntList(List<?> value, Neo4jTypes.AnyType inner) {
        return new Neo4jValue(value, Neo4jTypes.NTList(inner));
    }

    public String toString() {
        return "Neo4jValue{value=" + this.value + ", type=" + this.type + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Neo4jValue that = (Neo4jValue)o;
        if (this.value != null ? !this.value.equals(that.value) : that.value != null) {
            return false;
        }
        return this.type.equals(that.type);
    }

    public int hashCode() {
        int result = this.value != null ? this.value.hashCode() : 0;
        result = 31 * result + this.type.hashCode();
        return result;
    }
}

