/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.input;

import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Arrays;
import org.neo4j.collection.primitive.PrimitiveLongCollections;
import org.neo4j.collection.primitive.PrimitiveLongIterator;
import org.neo4j.helpers.Exceptions;
import org.neo4j.unsafe.impl.batchimport.cache.idmapping.string.DuplicateInputIdException;
import org.neo4j.unsafe.impl.batchimport.input.Collector;
import org.neo4j.unsafe.impl.batchimport.input.InputException;
import org.neo4j.unsafe.impl.batchimport.input.InputRelationship;

public class BadCollector
implements Collector {
    public static final int BAD_RELATIONSHIPS = 1;
    public static final int DUPLICATE_NODES = 2;
    public static final int EXTRA_COLUMNS = 4;
    public static final int COLLECT_ALL = 7;
    private final PrintStream out;
    private final int tolerance;
    private final int collect;
    private long[] leftOverDuplicateNodeIds = new long[10];
    private int leftOverDuplicateNodeIdsCursor;
    private volatile int badEntries;
    public static final int UNLIMITED_TOLERANCE = -1;

    public BadCollector(OutputStream out, int tolerance, int collect) {
        this.out = new PrintStream(out);
        this.tolerance = tolerance;
        this.collect = collect;
    }

    @Override
    public void collectBadRelationship(final InputRelationship relationship, final Object specificValue) {
        this.checkTolerance(1, new ProblemReporter(){
            private final String message;
            {
                this.message = String.format("%s referring to missing node %s", relationship, specificValue);
            }

            @Override
            public String message() {
                return this.message;
            }

            @Override
            public InputException exception() {
                return new InputException(this.message);
            }
        });
    }

    @Override
    public void collectDuplicateNode(final Object id, long actualId, final String group, final String firstSource, final String otherSource) {
        this.checkTolerance(2, new ProblemReporter(){

            @Override
            public String message() {
                return DuplicateInputIdException.message(id, group, firstSource, otherSource);
            }

            @Override
            public InputException exception() {
                return new DuplicateInputIdException(id, group, firstSource, otherSource);
            }
        });
        if (this.leftOverDuplicateNodeIdsCursor == this.leftOverDuplicateNodeIds.length) {
            this.leftOverDuplicateNodeIds = Arrays.copyOf(this.leftOverDuplicateNodeIds, this.leftOverDuplicateNodeIds.length * 2);
        }
        this.leftOverDuplicateNodeIds[this.leftOverDuplicateNodeIdsCursor++] = actualId;
    }

    @Override
    public void collectExtraColumns(final String source, final long row, final String value) {
        this.checkTolerance(4, new ProblemReporter(){
            private final String message;
            {
                this.message = String.format("Extra column not present in header on line %d in %s with value %s", row, source, value);
            }

            @Override
            public String message() {
                return this.message;
            }

            @Override
            public InputException exception() {
                return new InputException(this.message);
            }
        });
    }

    @Override
    public PrimitiveLongIterator leftOverDuplicateNodesIds() {
        this.leftOverDuplicateNodeIds = Arrays.copyOf(this.leftOverDuplicateNodeIds, this.leftOverDuplicateNodeIdsCursor);
        Arrays.sort(this.leftOverDuplicateNodeIds);
        return PrimitiveLongCollections.iterator((long[])this.leftOverDuplicateNodeIds);
    }

    @Override
    public void close() {
        this.out.flush();
    }

    @Override
    public int badEntries() {
        return this.badEntries;
    }

    private boolean collects(int bit) {
        return (this.collect & bit) != 0;
    }

    private void checkTolerance(int bit, ProblemReporter report) {
        boolean collect = this.collects(bit);
        if (collect) {
            this.out.println(report.message());
            ++this.badEntries;
        }
        if (!collect || this.tolerance != -1 && this.badEntries > this.tolerance) {
            InputException exception = report.exception();
            throw collect ? (InputException)Exceptions.withMessage((Throwable)exception, (String)String.format("Too many bad entries %d, where last one was: %s", this.badEntries, exception.getMessage())) : exception;
        }
    }

    private static interface ProblemReporter {
        public String message();

        public InputException exception();
    }
}

