/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.util.dbstructure;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.neo4j.helpers.Strings;
import org.neo4j.kernel.api.schema_new.LabelSchemaDescriptor;
import org.neo4j.kernel.api.schema_new.RelationTypeSchemaDescriptor;
import org.neo4j.kernel.api.schema_new.SchemaDescriptorFactory;
import org.neo4j.kernel.api.schema_new.constaints.ConstraintDescriptorFactory;
import org.neo4j.kernel.api.schema_new.constaints.NodeExistenceConstraintDescriptor;
import org.neo4j.kernel.api.schema_new.constaints.RelExistenceConstraintDescriptor;
import org.neo4j.kernel.api.schema_new.constaints.UniquenessConstraintDescriptor;
import org.neo4j.kernel.api.schema_new.index.NewIndexDescriptor;
import org.neo4j.kernel.api.schema_new.index.NewIndexDescriptorFactory;
import org.neo4j.kernel.impl.util.dbstructure.ArgumentFormatter;

public enum DbStructureArgumentFormatter implements ArgumentFormatter
{
    INSTANCE;

    private static List<String> IMPORTS;

    @Override
    public Collection<String> imports() {
        return IMPORTS;
    }

    @Override
    public void formatArgument(Appendable builder, Object arg) throws IOException {
        if (arg == null) {
            builder.append("null");
        } else if (arg instanceof String) {
            builder.append('\"');
            Strings.escape(builder, arg.toString());
            builder.append('\"');
        } else if (arg instanceof Long) {
            builder.append(arg.toString());
            builder.append('L');
        } else if (arg instanceof Integer) {
            builder.append(arg.toString());
        } else if (arg instanceof Double) {
            double d = (Double)arg;
            if (Double.isNaN(d)) {
                builder.append("Double.NaN");
            } else if (Double.isInfinite(d)) {
                builder.append(d < 0.0 ? "Double.NEGATIVE_INFINITY" : "Double.POSITIVE_INFINITY");
            } else {
                builder.append(arg.toString());
                builder.append('d');
            }
        } else if (arg instanceof NewIndexDescriptor) {
            NewIndexDescriptor descriptor = (NewIndexDescriptor)arg;
            int labelId = descriptor.schema().getLabelId();
            builder.append(String.format("NewIndexDescriptorFactory.forLabel( %d, %s )", labelId, this.asString(descriptor.schema().getPropertyIds())));
        } else if (arg instanceof LabelSchemaDescriptor) {
            LabelSchemaDescriptor descriptor = (LabelSchemaDescriptor)arg;
            int labelId = descriptor.getLabelId();
            builder.append(String.format("SchemaDescriptorFactory.forLabel( %d, %s )", labelId, this.asString(descriptor.getPropertyIds())));
        } else if (arg instanceof UniquenessConstraintDescriptor) {
            UniquenessConstraintDescriptor constraint = (UniquenessConstraintDescriptor)arg;
            int labelId = constraint.schema().getLabelId();
            builder.append(String.format("ConstraintDescriptorFactory.uniqueForLabel( %d, %s )", labelId, this.asString(constraint.schema().getPropertyIds())));
        } else if (arg instanceof NodeExistenceConstraintDescriptor) {
            NodeExistenceConstraintDescriptor constraint = (NodeExistenceConstraintDescriptor)arg;
            int labelId = constraint.schema().getLabelId();
            builder.append(String.format("ConstraintDescriptorFactory.existsForLabel( %d, %s )", labelId, this.asString(constraint.schema().getPropertyIds())));
        } else if (arg instanceof RelExistenceConstraintDescriptor) {
            RelationTypeSchemaDescriptor descriptor = ((RelExistenceConstraintDescriptor)arg).schema();
            int relTypeId = descriptor.getRelTypeId();
            builder.append(String.format("ConstraintDescriptorFactory.existsForReltype( %d, %s )", relTypeId, this.asString(descriptor.getPropertyIds())));
        } else {
            throw new IllegalArgumentException(String.format("Can't handle argument of type: %s with value: %s", arg.getClass(), arg));
        }
    }

    private String asString(int[] propertyIds) {
        List strings = Arrays.stream(propertyIds).mapToObj(i -> "" + i).collect(Collectors.toList());
        return String.join((CharSequence)", ", strings);
    }

    static {
        IMPORTS = Arrays.asList(ConstraintDescriptorFactory.class.getCanonicalName(), UniquenessConstraintDescriptor.class.getCanonicalName(), RelExistenceConstraintDescriptor.class.getCanonicalName(), NodeExistenceConstraintDescriptor.class.getCanonicalName(), LabelSchemaDescriptor.class.getCanonicalName(), SchemaDescriptorFactory.class.getCanonicalName(), NewIndexDescriptor.class.getCanonicalName(), NewIndexDescriptorFactory.class.getCanonicalName());
    }
}

