/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.locking;

import java.util.HashMap;
import java.util.Map;
import org.neo4j.collection.primitive.hopscotch.HopScotchHashingAlgorithm;
import org.neo4j.kernel.api.properties.DefinedProperty;
import org.neo4j.kernel.api.properties.Property;
import org.neo4j.kernel.api.schema_new.IndexQuery;
import org.neo4j.kernel.impl.util.concurrent.LockWaitStrategies;
import org.neo4j.storageengine.api.lock.ResourceType;
import org.neo4j.storageengine.api.lock.WaitStrategy;

public enum ResourceTypes implements ResourceType
{
    NODE(0, LockWaitStrategies.INCREMENTAL_BACKOFF),
    RELATIONSHIP(1, LockWaitStrategies.INCREMENTAL_BACKOFF),
    GRAPH_PROPS(2, LockWaitStrategies.INCREMENTAL_BACKOFF),
    SCHEMA(3, LockWaitStrategies.INCREMENTAL_BACKOFF),
    INDEX_ENTRY(4, LockWaitStrategies.INCREMENTAL_BACKOFF),
    LEGACY_INDEX(5, LockWaitStrategies.INCREMENTAL_BACKOFF);

    private static final Map<Integer, ResourceType> idToType;
    private final int typeId;
    private final WaitStrategy waitStrategy;

    private ResourceTypes(int typeId, WaitStrategy waitStrategy) {
        this.typeId = typeId;
        this.waitStrategy = waitStrategy;
    }

    @Override
    public int typeId() {
        return this.typeId;
    }

    @Override
    public WaitStrategy waitStrategy() {
        return this.waitStrategy;
    }

    public static long legacyIndexResourceId(String name, String key) {
        return (long)name.hashCode() << 32 | (long)key.hashCode();
    }

    public static long indexEntryResourceId(long labelId, IndexQuery.ExactPredicate ... predicates) {
        return ResourceTypes.indexEntryResourceId(labelId, predicates, 0);
    }

    private static long indexEntryResourceId(long labelId, IndexQuery.ExactPredicate[] predicates, int i) {
        int propertyKeyId = predicates[i].propertyKeyId();
        Object value = predicates[i].value();
        long hash = ResourceTypes.indexEntryResourceId(labelId, propertyKeyId, ResourceTypes.stringOf(propertyKeyId, value));
        if (++i < predicates.length) {
            hash = ResourceTypes.hash(hash + ResourceTypes.indexEntryResourceId(labelId, predicates, i));
        }
        return hash;
    }

    private static long indexEntryResourceId(long labelId, long propertyKeyId, String propertyValue) {
        long hob = ResourceTypes.hash(labelId + (long)ResourceTypes.hash(propertyKeyId));
        return (hob <<= 32) + (long)propertyValue.hashCode();
    }

    private static String stringOf(int propertyKeyId, Object value) {
        if (null != value) {
            DefinedProperty property = Property.property(propertyKeyId, value);
            return property.valueAsString();
        }
        return "";
    }

    private static int hash(long value) {
        return HopScotchHashingAlgorithm.DEFAULT_HASHING.hash(value);
    }

    public static long graphPropertyResource() {
        return 0L;
    }

    public static long schemaResource() {
        return 0L;
    }

    public static ResourceType fromId(int typeId) {
        return idToType.get(typeId);
    }

    static {
        idToType = new HashMap<Integer, ResourceType>();
        for (ResourceTypes resourceTypes : ResourceTypes.values()) {
            idToType.put(resourceTypes.typeId, resourceTypes);
        }
    }
}

