/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.state;

import java.util.Iterator;
import org.apache.commons.lang3.ArrayUtils;
import org.neo4j.collection.primitive.Primitive;
import org.neo4j.collection.primitive.PrimitiveIntSet;
import org.neo4j.cursor.Cursor;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.kernel.api.exceptions.EntityNotFoundException;
import org.neo4j.kernel.api.properties.DefinedProperty;
import org.neo4j.kernel.api.properties.Property;
import org.neo4j.kernel.api.schema_new.OrderedPropertyValues;
import org.neo4j.kernel.api.schema_new.SchemaDescriptorPredicates;
import org.neo4j.kernel.api.schema_new.index.NewIndexDescriptor;
import org.neo4j.kernel.impl.api.KernelStatement;
import org.neo4j.kernel.impl.api.operations.EntityReadOperations;
import org.neo4j.kernel.impl.api.operations.SchemaReadOperations;
import org.neo4j.kernel.impl.api.schema.NodeSchemaMatcher;
import org.neo4j.kernel.impl.util.Validators;
import org.neo4j.storageengine.api.NodeItem;
import org.neo4j.storageengine.api.PropertyItem;

public class IndexTxStateUpdater {
    private final SchemaReadOperations schemaReadOps;
    private final EntityReadOperations readOps;
    private final NodeSchemaMatcher nodeIndexMatcher;

    public IndexTxStateUpdater(SchemaReadOperations schemaReadOps, EntityReadOperations readOps) {
        this.schemaReadOps = schemaReadOps;
        this.readOps = readOps;
        this.nodeIndexMatcher = new NodeSchemaMatcher(readOps);
    }

    public void onLabelChange(KernelStatement state, int labelId, NodeItem node, LabelChangeType changeType) throws EntityNotFoundException {
        PrimitiveIntSet nodePropertyIds = Primitive.intSet();
        nodePropertyIds.addAll(this.readOps.nodeGetPropertyKeys(state, node).iterator());
        Iterator indexes = Iterators.concat((Iterator[])new Iterator[]{this.schemaReadOps.indexesGetForLabel(state, labelId), this.schemaReadOps.uniqueIndexesGetForLabel(state, labelId)});
        while (indexes.hasNext()) {
            NewIndexDescriptor index = (NewIndexDescriptor)indexes.next();
            int[] indexPropertyIds = index.schema().getPropertyIds();
            if (!IndexTxStateUpdater.nodeHasIndexProperties(nodePropertyIds, indexPropertyIds)) continue;
            OrderedPropertyValues values = this.getOrderedPropertyValues(state, node, indexPropertyIds);
            if (changeType == LabelChangeType.ADDED_LABEL) {
                state.txState().indexDoUpdateEntry(index.schema(), node.id(), null, values);
                continue;
            }
            state.txState().indexDoUpdateEntry(index.schema(), node.id(), values, null);
        }
    }

    public void onPropertyAdd(KernelStatement state, NodeItem node, DefinedProperty after) throws EntityNotFoundException {
        Iterator<NewIndexDescriptor> indexes = this.getIndexesInvolvingProperty(state, after.propertyKeyId());
        this.nodeIndexMatcher.onMatchingSchema(state, indexes, node, after.propertyKeyId(), index -> {
            Validators.INDEX_VALUE_VALIDATOR.validate(after.value());
            OrderedPropertyValues values = this.getOrderedPropertyValues(state, node, after, index.schema().getPropertyIds());
            state.txState().indexDoUpdateEntry(index.schema(), node.id(), null, values);
        });
    }

    public void onPropertyRemove(KernelStatement state, NodeItem node, DefinedProperty before) throws EntityNotFoundException {
        Iterator<NewIndexDescriptor> indexes = this.getIndexesInvolvingProperty(state, before.propertyKeyId());
        this.nodeIndexMatcher.onMatchingSchema(state, indexes, node, before.propertyKeyId(), index -> {
            OrderedPropertyValues values = this.getOrderedPropertyValues(state, node, before, index.schema().getPropertyIds());
            state.txState().indexDoUpdateEntry(index.schema(), node.id(), values, null);
        });
    }

    public void onPropertyChange(KernelStatement state, NodeItem node, DefinedProperty before, DefinedProperty after) throws EntityNotFoundException {
        assert (before.propertyKeyId() == after.propertyKeyId());
        Iterator<NewIndexDescriptor> indexes = this.getIndexesInvolvingProperty(state, before.propertyKeyId());
        this.nodeIndexMatcher.onMatchingSchema(state, indexes, node, before.propertyKeyId(), index -> {
            Validators.INDEX_VALUE_VALIDATOR.validate(after.value());
            int[] indexPropertyIds = index.schema().getPropertyIds();
            Object[] valuesBefore = new Object[indexPropertyIds.length];
            Object[] valuesAfter = new Object[indexPropertyIds.length];
            for (int i = 0; i < indexPropertyIds.length; ++i) {
                Object value;
                int indexPropertyId = indexPropertyIds[i];
                if (indexPropertyId == before.propertyKeyId()) {
                    valuesBefore[i] = before.value();
                    valuesAfter[i] = after.value();
                    continue;
                }
                valuesBefore[i] = value = this.readOps.nodeGetProperty(state, node, indexPropertyId);
                valuesAfter[i] = value;
            }
            state.txState().indexDoUpdateEntry(index.schema(), node.id(), OrderedPropertyValues.ofUndefined(valuesBefore), OrderedPropertyValues.ofUndefined(valuesAfter));
        });
    }

    private OrderedPropertyValues getOrderedPropertyValues(KernelStatement state, NodeItem node, int[] indexPropertyIds) {
        return this.getOrderedPropertyValues(state, node, DefinedProperty.NO_SUCH_PROPERTY, indexPropertyIds);
    }

    private OrderedPropertyValues getOrderedPropertyValues(KernelStatement state, NodeItem node, DefinedProperty changedProperty, int[] indexPropertyIds) {
        int k;
        DefinedProperty[] values = new DefinedProperty[indexPropertyIds.length];
        Cursor<PropertyItem> propertyCursor = this.readOps.nodeGetProperties(state, node);
        while (propertyCursor.next()) {
            PropertyItem property = (PropertyItem)propertyCursor.get();
            int k2 = ArrayUtils.indexOf((int[])indexPropertyIds, (int)property.propertyKeyId());
            if (k2 < 0) continue;
            values[k2] = indexPropertyIds[k2] == changedProperty.propertyKeyId() ? changedProperty : Property.property(indexPropertyIds[k2], property.value());
        }
        if (changedProperty != DefinedProperty.NO_SUCH_PROPERTY && (k = ArrayUtils.indexOf((int[])indexPropertyIds, (int)changedProperty.propertyKeyId())) >= 0) {
            values[k] = changedProperty;
        }
        return OrderedPropertyValues.of(values);
    }

    private static boolean nodeHasIndexProperties(PrimitiveIntSet nodeProperties, int[] indexPropertyIds) {
        for (int indexPropertyId : indexPropertyIds) {
            if (nodeProperties.contains(indexPropertyId)) continue;
            return false;
        }
        return true;
    }

    private Iterator<NewIndexDescriptor> getIndexesInvolvingProperty(KernelStatement state, int propertyId) {
        Iterator allIndexes = Iterators.concat((Iterator[])new Iterator[]{this.schemaReadOps.indexesGetAll(state), this.schemaReadOps.uniqueIndexesGetAll(state)});
        return Iterators.filter(SchemaDescriptorPredicates.hasProperty(propertyId), (Iterator)allIndexes);
    }

    public static enum LabelChangeType {
        ADDED_LABEL,
        REMOVED_LABEL;

    }
}

