/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.index.sampling;

import org.neo4j.kernel.api.exceptions.index.IndexNotFoundKernelException;
import org.neo4j.kernel.api.index.InternalIndexState;
import org.neo4j.kernel.impl.api.index.IndexProxy;
import org.neo4j.kernel.impl.api.index.IndexStoreView;
import org.neo4j.kernel.impl.api.index.sampling.IndexSamplingJob;
import org.neo4j.kernel.impl.util.DurationLogger;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;
import org.neo4j.storageengine.api.schema.IndexReader;
import org.neo4j.storageengine.api.schema.IndexSample;
import org.neo4j.storageengine.api.schema.IndexSampler;

class OnlineIndexSamplingJob
implements IndexSamplingJob {
    private final long indexId;
    private final IndexProxy indexProxy;
    private final IndexStoreView storeView;
    private final Log log;
    private final String indexUserDescription;

    OnlineIndexSamplingJob(long indexId, IndexProxy indexProxy, IndexStoreView storeView, String indexUserDescription, LogProvider logProvider) {
        this.indexId = indexId;
        this.indexProxy = indexProxy;
        this.storeView = storeView;
        this.log = logProvider.getLog(this.getClass());
        this.indexUserDescription = indexUserDescription;
    }

    @Override
    public long indexId() {
        return this.indexId;
    }

    @Override
    public void run() {
        try (DurationLogger durationLogger = new DurationLogger(this.log, "Sampling index " + this.indexUserDescription);){
            try (IndexReader reader = this.indexProxy.newReader();){
                IndexSampler sampler = reader.createSampler();
                IndexSample sample = sampler.sampleIndex();
                if (this.indexProxy.getState() == InternalIndexState.ONLINE) {
                    this.storeView.replaceIndexCounts(this.indexId, sample.uniqueValues(), sample.sampleSize(), sample.indexSize());
                    durationLogger.markAsFinished();
                    this.log.info(String.format("Sampled index %s with %d unique values in sample of avg size %d taken from index containing %d entries", this.indexUserDescription, sample.uniqueValues(), sample.sampleSize(), sample.indexSize()));
                } else {
                    durationLogger.markAsAborted("Index no longer ONLINE");
                }
            }
            catch (IndexNotFoundKernelException e) {
                durationLogger.markAsAborted("Attempted to sample missing/already deleted index " + this.indexUserDescription);
            }
        }
    }
}

