/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.schema_new.index;

import java.util.function.Predicate;
import org.neo4j.kernel.api.TokenNameLookup;
import org.neo4j.kernel.api.schema_new.LabelSchemaDescriptor;
import org.neo4j.kernel.api.schema_new.LabelSchemaSupplier;
import org.neo4j.kernel.api.schema_new.SchemaUtil;

public class NewIndexDescriptor
implements LabelSchemaSupplier {
    private final LabelSchemaDescriptor schema;
    private final Type type;

    NewIndexDescriptor(LabelSchemaDescriptor schema, Type type) {
        this.schema = schema;
        this.type = type;
    }

    public Type type() {
        return this.type;
    }

    @Override
    public LabelSchemaDescriptor schema() {
        return this.schema;
    }

    public String userDescription(TokenNameLookup tokenNameLookup) {
        return String.format("Index( %s, %s )", this.type.name(), this.schema.userDescription(tokenNameLookup));
    }

    public boolean isSame(Supplier supplier) {
        return this.equals(supplier.getIndexDescriptor());
    }

    public boolean equals(Object o) {
        if (o != null && o instanceof NewIndexDescriptor) {
            NewIndexDescriptor that = (NewIndexDescriptor)o;
            return this.type() == that.type() && this.schema().equals(that.schema());
        }
        return false;
    }

    public int hashCode() {
        return this.type.hashCode() & this.schema.hashCode();
    }

    public String toString() {
        return this.userDescription(SchemaUtil.idTokenNameLookup);
    }

    public static interface Supplier {
        public NewIndexDescriptor getIndexDescriptor();
    }

    public static enum Filter implements Predicate<NewIndexDescriptor>
    {
        GENERAL{

            @Override
            public boolean test(NewIndexDescriptor index) {
                return index.type == Type.GENERAL;
            }
        }
        ,
        UNIQUE{

            @Override
            public boolean test(NewIndexDescriptor index) {
                return index.type == Type.UNIQUE;
            }
        }
        ,
        ANY{

            @Override
            public boolean test(NewIndexDescriptor index) {
                return true;
            }
        };

    }

    public static enum Type {
        GENERAL,
        UNIQUE;

    }
}

