/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.query;

import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import java.util.function.LongSupplier;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.neo4j.kernel.api.query.ExecutingQueryStatus;
import org.neo4j.kernel.api.query.PlannerInfo;
import org.neo4j.kernel.api.query.QuerySnapshot;
import org.neo4j.kernel.api.query.SimpleState;
import org.neo4j.kernel.api.query.WaitingOnLockEvent;
import org.neo4j.kernel.api.query.WaitingOnQuery;
import org.neo4j.kernel.impl.locking.LockTracer;
import org.neo4j.kernel.impl.locking.LockWaitEvent;
import org.neo4j.kernel.impl.query.clientconnection.ClientConnectionInfo;
import org.neo4j.storageengine.api.lock.ResourceType;
import org.neo4j.time.CpuClock;
import org.neo4j.time.SystemNanoClock;

public class ExecutingQuery {
    private static final AtomicLongFieldUpdater<ExecutingQuery> WAIT_TIME = AtomicLongFieldUpdater.newUpdater(ExecutingQuery.class, "waitTimeNanos");
    private final long queryId;
    private final LockTracer lockTracer = this::waitForLock;
    private final String username;
    private final ClientConnectionInfo clientConnection;
    private final String queryText;
    private final Map<String, Object> queryParameters;
    private final long startTimeNanos;
    private final long startTimestampMillis;
    private long planningDoneNanos;
    private final Thread threadExecutingTheQuery;
    private final LongSupplier activeLockCount;
    private final SystemNanoClock clock;
    private final CpuClock cpuClock;
    private final long cpuTimeNanosWhenQueryStarted;
    private final Map<String, Object> transactionAnnotationData;
    private PlannerInfo plannerInfo;
    private volatile ExecutingQueryStatus status = SimpleState.planning();
    private volatile long waitTimeNanos;

    public ExecutingQuery(long queryId, ClientConnectionInfo clientConnection, String username, String queryText, Map<String, Object> queryParameters, Map<String, Object> transactionAnnotationData, LongSupplier activeLockCount, Thread threadExecutingTheQuery, SystemNanoClock clock, CpuClock cpuClock) {
        this.cpuTimeNanosWhenQueryStarted = cpuClock.cpuTimeNanos(threadExecutingTheQuery);
        this.startTimeNanos = clock.nanos();
        this.startTimestampMillis = clock.millis();
        this.queryId = queryId;
        this.clientConnection = clientConnection;
        this.username = username;
        this.queryText = queryText;
        this.queryParameters = queryParameters;
        this.transactionAnnotationData = transactionAnnotationData;
        this.activeLockCount = activeLockCount;
        this.threadExecutingTheQuery = threadExecutingTheQuery;
        this.cpuClock = cpuClock;
        this.clock = clock;
    }

    public void planningCompleted(PlannerInfo plannerInfo) {
        this.plannerInfo = plannerInfo;
        this.planningDoneNanos = this.clock.nanos();
        this.status = SimpleState.running();
    }

    public LockTracer lockTracer() {
        return this.lockTracer;
    }

    public void waitsForQuery(ExecutingQuery child) {
        if (child == null) {
            WAIT_TIME.addAndGet(this, this.status.waitTimeNanos(this.clock.nanos()));
            this.status = SimpleState.running();
        } else {
            this.status = new WaitingOnQuery(child, this.clock.nanos());
        }
    }

    public QuerySnapshot snapshot() {
        long currentTimeNanos;
        ExecutingQueryStatus status;
        do {
            status = this.status;
            long waitTimeNanos = this.waitTimeNanos;
            long cpuTimeNanos = this.cpuClock.cpuTimeNanos(this.threadExecutingTheQuery);
            currentTimeNanos = this.clock.nanos();
        } while (this.status != status);
        long planningDoneNanos = this.planningDoneNanos;
        PlannerInfo planner = status.isPlanning() ? null : this.plannerInfo;
        long activeLockCount = this.activeLockCount.getAsLong();
        long planningTimeNanos = (status.isPlanning() ? currentTimeNanos : planningDoneNanos) - this.startTimeNanos;
        long elapsedTimeNanos = currentTimeNanos - this.startTimeNanos;
        return new QuerySnapshot(this, planner, TimeUnit.NANOSECONDS.toMillis(planningTimeNanos), TimeUnit.NANOSECONDS.toMillis(elapsedTimeNanos), TimeUnit.NANOSECONDS.toMillis(cpuTimeNanos -= this.cpuTimeNanosWhenQueryStarted), TimeUnit.NANOSECONDS.toMillis(waitTimeNanos += status.waitTimeNanos(currentTimeNanos)), status.name(), status.toMap(currentTimeNanos), activeLockCount);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExecutingQuery that = (ExecutingQuery)o;
        return this.queryId == that.queryId;
    }

    public int hashCode() {
        return (int)(this.queryId ^ this.queryId >>> 32);
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }

    public long internalQueryId() {
        return this.queryId;
    }

    public String username() {
        return this.username;
    }

    public String queryText() {
        return this.queryText;
    }

    public Map<String, Object> queryParameters() {
        return this.queryParameters;
    }

    public long startTimestampMillis() {
        return this.startTimestampMillis;
    }

    public Map<String, Object> transactionAnnotationData() {
        return this.transactionAnnotationData;
    }

    ClientConnectionInfo clientConnection() {
        return this.clientConnection;
    }

    public String connectionDetailsForLogging() {
        return this.clientConnection.asConnectionDetails();
    }

    private LockWaitEvent waitForLock(boolean exclusive, ResourceType resourceType, long[] resourceIds) {
        WaitingOnLockEvent event = new WaitingOnLockEvent(exclusive ? "EXCLUSIVE" : "SHARED", resourceType, resourceIds, this, this.clock.nanos(), this.status);
        this.status = event;
        return event;
    }

    void doneWaitingOnLock(WaitingOnLockEvent waiting) {
        if (this.status != waiting) {
            return;
        }
        WAIT_TIME.addAndGet(this, waiting.waitTimeNanos(this.clock.nanos()));
        this.status = waiting.previousStatus();
    }
}

